
/*
 KSolve - Puzzle solving program.
 Copyright (C) 2007  Kre Krig

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

// Code for reading the puzzle definition.

#include "data.h"
#include "move.h"
#include "rules.h"
#include "checks.h"
#include <iostream>
#include <sstream>
#include <fstream>
using namespace std;

rules::rules(string filename){
   ifstream fin(filename.c_str());
   if(!fin.good()){
      cout << "Cant open puzzle definition!" << endl;
      exit(-1);
   }
   
//   ignore = NULL;
      
   while( !fin.eof() ){
         string command;
         fin >> command;
         
         if(command == "Name"){
            getline(fin, name);
         }
         else if(command == "Set"){  // Testas i stllet fr Perm/Orient
            string setname;
            fin >> setname;
            map<string,dataset>::iterator iter = datasets.find(setname);
            if( iter != datasets.end() ) {
               cerr << "Set " << setname << " declared more than once." << endl;
               exit(-1);
            }            
            fin >> datasets[setname].size;
            if( fin.fail() || datasets[setname].size < 1 ){
               cerr << "Set " << setname << " does not have positive size." << endl;
               exit(-1);
            }
            fin >> datasets[setname].omod;
            if( fin.fail() || datasets[setname].omod < 0 ){
               cerr << "Pieces in " << setname << " does not have a positive (or zero) number of possible orientations." << endl;
               exit(-1);
            }
            datasets[setname].ptabletype = TABLE_TYPE_NONE;
            datasets[setname].otabletype = TABLE_TYPE_NONE;
         }
         else if(command == "Move"){
            string movename;
            string setname;
            fin >> movename;
            map<string, map<string, submove> >::iterator iter = moves.find(movename);
            if( iter != moves.end() ) {
               cerr << "Move " << movename << " declared more than once." << endl;
               exit(-1);
            }
            fin >> setname;
            while( setname != "End" ){
               map<string,dataset>::iterator iter3 = datasets.find(setname);
               if( iter3 == datasets.end() ) {
                  cerr << "Set " << setname << " used in move " << movename << " not previously declared." << endl;
                  exit(-1);
               }            
               map<string, submove>::iterator iter2 = moves[movename].find(setname);
               if( iter2 != moves[movename].end() ){
                  cerr << "Set " << setname << " declared more than once in move " << movename << endl;
                  exit(-1);
               }
//               submove tmpm;
               moves[movename][setname].size = datasets[setname].size;
               moves[movename][setname].permute = new int[moves[movename][setname].size];
               moves[movename][setname].orient = new int[moves[movename][setname].size];
              
               for(int i = 0; i < datasets[setname].size; i++){
                  int tmp;
                  fin >> tmp;
                  if( fin.fail() ){
                     cerr << "Error reading " << setname << " permutation for move " << movename << endl;
                     exit(-1);
                  }
                  //tmpm.permute.push_back( tmp );
                  moves[movename][setname].permute[i] = tmp;
               }
               for(int i = 0; i < datasets[setname].size; i++){
                  int tmp;
                  fin >> tmp;
                  if( fin.fail() ){
                     cerr << "Error reading " << setname << " orientation for move " << movename << endl;
                     exit(-1);
                  }
                  // tmpm.orient.push_back( tmp );
                  moves[movename][setname].orient[i] = tmp;
               }
               
//               if( !uniquePermutation( tmpm.permute ) ){
               if( !uniquePermutation( moves[movename][setname].permute, moves[movename][setname].size ) ){
                  cerr << "Permutation for set " << setname << " for move " << movename << " is not a permutation." << endl;
                  exit(-1);
               }
//               moves[movename][setname] = tmpm ;
               fin >> setname;
            }
         }
         else if(command == "Solved"){
            string setname;
            fin >> setname;  
            while( setname != "End" ){
               map<string,dataset>::iterator iter3 = datasets.find(setname);
               if( iter3 == datasets.end() ) {
                  cerr << "Set " << setname << " used in solved state is not previously declared." << endl;
                  exit(-1);
               }            

               map<string, substate>::iterator iter = solved.find(setname);
               if( iter != solved.end() ){
                  cerr << "Set " << setname << " declared more than once for solved position. " << endl
                       << "Multiple solved positions not possible" << endl;
                  exit(-1);
               }
//               substate tmps;
               solved[setname].permutation = new int[datasets[setname].size];
               solved[setname].orientation = new int[datasets[setname].size];
               solved[setname].size = datasets[setname].size;
               if(solved[setname].permutation == NULL || solved[setname].orientation == NULL){
                  cerr << "Could not allocate memory in rules(...)" << endl;
                  exit(-1);
               }
               
               for(int i = 0; i < datasets[setname].size; i++){
                  int tmp;
                  fin >> tmp;
                  if( fin.fail() ){
                     cerr << "Error reading " << setname << " permutation for solved state." << endl;
                     exit(-1);
                  }
                  solved[setname].permutation[i] = tmp;
               }
               for(int i = 0; i < datasets[setname].size; i++){
                  int tmp;
                  fin >> tmp;
                  if( fin.fail() ){
                     cerr << "Error reading " << setname << " orientation for solved state." << endl;
                     exit(-1);
                  }
                  solved[setname].orientation[i] = tmp;
               }
               datasets[setname].uniqueperm = uniquePermutation( solved[setname].permutation, solved[setname].size );
//               solved[setname].permutation  tmps.permutation
               fin >> setname;
            }
         }
         else if( command == "ForbiddenPairs" ){
            string movename1, movename2;  
            fin >> movename1;
            while( movename1 != "End" ) {
               if( fin.fail() ){
                  cerr << "Error reading forbidden pairs." << endl;
                  exit(-1);
               }
               map<string, map<string, submove> >::iterator iter = moves.find(movename1);
               if( iter == moves.end() ){
                  cerr << "Move " << movename1 << " used in forbidden pairs is not previously declared." << endl;
                  exit(-1);
               }
               
               fin >> movename2;
               if( fin.fail() ){
                  cerr << "Error reading forbidden pairs." << endl;
                  exit(-1);
               }
               iter = moves.find(movename2);
               if( iter == moves.end() ){
                  cerr << "Move " << movename2 << " used in forbidden pairs is not previously declared." << endl;
                  exit(-1);
               }
               
               movepair tmp;
               tmp.a = movename1;
               tmp.b = movename2;
               forbidden.push_back(tmp);
               fin >> movename1;
            }
         }
         else if( command == "ParallelMoves" ){
            string line, tmp;
            vector< vector<string> > parallel;
            vector<string> tmp_vec;
            
            getline(fin, line);
            getline(fin, line); // For some reason the first one was an empty line
            
            istringstream input(line);
            input >> tmp;
            while( tmp != "End" ){
               map<string, map<string, submove> >::iterator error_iter = moves.find(tmp);
               if( error_iter == moves.end() ){
                  cerr << "Move " << tmp << " used in ParallelMoves is not previously declared." << endl;
                  exit(-1);
               }

               tmp_vec.clear();
               tmp_vec.push_back( tmp );
               
               while( !input.eof() ){
                  input >> tmp;
                  if( !input.fail() ){
                     error_iter = moves.find(tmp);
                     if( error_iter == moves.end() ){
                        cerr << "Move " << tmp << " used in ParallelMoves is not previously declared." << endl;
                        exit(-1);
                     }
                     tmp_vec.push_back(tmp);
                  }
               }
               
               parallel.push_back( tmp_vec );
               getline(fin, line);
               input.str(line);
               input.clear();
               input >> tmp;
            }

            for(int i = 0; (i+1) < parallel.size(); i++){
               for(int j = i+1; j < parallel.size(); j++){
                  for(int k = 0; k < parallel[i].size(); k++){
                     for(int l = 0; l < parallel[j].size(); l++){
                        movepair tmp_pair;
                        tmp_pair.a = parallel[i][k];
                        tmp_pair.b = parallel[j][l];
                        forbidden.push_back(tmp_pair);
                     }
                  }
               }
            }
         }
         else if( command == "ForbiddenGroups" ){
            string line, move1;
            vector<string> group;
            getline(fin, line);
            getline(fin, line);
            istringstream input(line);
            input >> move1;
            while( move1 != "End" ){
               map<string, map<string, submove> >::iterator error_iter = moves.find(move1);
               if( error_iter == moves.end() ){
                  cerr << "Move " << move1 << " used in ForbiddeGroups is not previously declared." << endl;
                  exit(-1);
               }
                   
               group.clear();
               group.push_back( move1 );
               while( !input.eof() ){
                  input >> move1;
                  if( !input.fail() ){
                     error_iter = moves.find(move1);
                     if( error_iter == moves.end() ){
                        cerr << "Move " << move1 << " used in ForbiddenGroups is not previously declared." << endl;
                        exit(-1);
                     }
                     group.push_back( move1 );
                  }
               }
               
               for(int i = 0; i < group.size(); i++){
                  for(int j = 0; j < group.size(); j++){
                     movepair tmp_pair;
                     tmp_pair.a = group[i];
                     tmp_pair.b = group[j];
                     forbidden.push_back(tmp_pair);
                  }
               }

               getline(fin, line);
               input.str( line );
               input.clear();    
               input >> move1;       
            }
         }
         else if( command == "Multiplicators" ){
            string newmove, move1, move2, line;
            fin >> newmove;
            while( newmove != "End" ){
               map<string, submove> move_vecs;
               map<string, map<string, submove> >::iterator iter = moves.find(newmove);
               if( iter != moves.end() ) {
                  cerr << "Move " << newmove << " defined by Multiplicator is previously declared." << endl;
                  exit(-1);
               }
               fin >> move1;
               if(move1 != "="){
                  cerr << "Incorrect Multilpicator syntax for move " << newmove << endl;
                  cerr << "Use    new_move = move1 move2 ..." << endl;
                  exit(-1);
               }
               getline(fin, line);
               istringstream input(line);

               input >> move1;
               move_vecs = moves[move1];
               while( !input.eof() ){
                  input >> move2;
                  if( !input.fail() ){
                     move_vecs = mergeMoves(move_vecs, moves[move2], datasets);
                  }
               }
               moves[ newmove ] = move_vecs;
               fin >> newmove;
            }
         }
         else if( command == "Ignore" ){
            string setname;
            fin >> setname;  
            while( setname != "End" ){
               map<string,dataset>::iterator iter3 = datasets.find(setname);
               if( iter3 == datasets.end() ) {
                  cerr << "Set " << setname << " used in Ignore is not previously declared." << endl;
                  exit(-1);
               }            

               map<string, substate>::iterator iter = ignore.find(setname);
               if( iter != ignore.end() ){
                  cerr << "Set " << setname << " declared more than once in ignore. " << endl;
                  exit(-1);
               }
//               substate tmps;
               ignore[setname].permutation = new int[datasets[setname].size];
               ignore[setname].orientation = new int[datasets[setname].size];
               ignore[setname].size = datasets[setname].size;
               if(ignore[setname].permutation == NULL || ignore[setname].orientation == NULL){
                  cerr << "Could not allocate memory in rules(...)" << endl;
                  exit(-1);
               }

               for(int i = 0; i < datasets[setname].size; i++){
                  int tmp;
                  fin >> tmp;
                  if( fin.fail() ){
                     cerr << "Error reading " << setname << " permutation to ignore." << endl;
                     exit(-1);
                  }
                  ignore[setname].permutation[i] = tmp;
               }
               for(int i = 0; i < datasets[setname].size; i++){
                  int tmp;
                  fin >> tmp;
                  if( fin.fail() ){
                     cerr << "Error reading " << setname << " orientation to ignore." << endl;
                     exit(-1);
                  }
                  ignore[setname].orientation[i] = tmp;    
               }
//               ignore[setname] = tmps;
               fin >> setname;
            }              
         }
         else if( command == "Block" ){
            map<string, set<int> > tmp_block;
            string setname, line;
            fin >> setname;
            while( setname != "End" ){
               map<string,dataset>::iterator iter3 = datasets.find(setname);
               set<int> tmp;
               if( iter3 == datasets.end() ) {
                  cerr << "Set " << setname << " used in Block is not previously declared." << endl;
                  exit(-1);
               }
               getline(fin, line); // To get past the linefeed
               getline(fin, line);
               istringstream input(line);
               int piece;
               while( !input.eof() ){
                  input >> piece;
                  if( piece > datasets[ setname ].size || piece <= 0 ) {
                     cerr << "Piece " << piece << " in Block, should not be in set " << setname << endl;
                     exit(-1);
                  }
                  if( !input.fail() ){
                     tmp.insert(piece);
                  }
               }
               tmp_block[setname] = tmp;
               fin >> setname;
            }
            blocks.insert( tmp_block );
         }
         else if( command == "#" ){ // Comment
            char buff[500];
            fin.getline(buff,500);
         }
         else if( command == "" ) {} // Empty line
         else
            cerr << "Unknown command " << command << endl;
   }    
}

void rules::print(void)
{
   cout << "Puzzle name: " << name << endl;
   map<string, dataset>::iterator iter;
   for(iter = datasets.begin(); iter != datasets.end(); iter++)
   {
      cout << (*iter).first << " has type " << iter->second.type << ", " << iter->second.size << " elements and is counted mod " << iter->second.omod << endl;    
   }
   cout << endl;
   
   map<string, map<string, submove> >::iterator iter2;
   for(iter2 = moves.begin(); iter2 != moves.end(); iter2++)
   {
      cout << "Move " << (*iter2).first << " moves the folowing sets" << endl;            
      map<string, submove>::iterator iter3;
      for(iter3 = iter2->second.begin(); iter3 != iter2->second.end(); iter3++){
         cout << (*iter3).first << endl;
         for( int i = 0; i < iter3->second.size; i++)
            cout << iter3->second.permute[i];         
         cout << endl;
         for( int i = 0; i < iter3->second.size; i++)
            cout << iter3->second.orient[i];         
         cout << endl;
            
      }
      cout << endl;
   }
   cout << "Solved state : " << endl;
   map<string, substate>::iterator iter4;   
   for(iter4 = solved.begin(); iter4 != solved.end(); iter4++){
      cout << (*iter4).first << endl;
      for( int i = 0; i < iter4->second.size; i++)
         cout << iter4->second.permutation[i];         
      cout << endl;
      for( int i = 0; i < iter4->second.size; i++)
         cout << iter4->second.orientation[i];         
      cout << endl;
   }
      
}

map<string, dataset> rules::getDatasets(){
   return datasets;            
}

map<string, substate> rules::getSolved(){
   return solved;            
}

map<string, map<string, submove> > rules::getMoves(){
   return moves;         
}

vector<movepair> rules::getForbiddenPairs(){
   return forbidden;                 
}

map<string, substate> rules::getIgnore(){
   return ignore;
}

set<map<string, set<int> > > rules::getBlocks(){
   return blocks;
}
