
// Functions for generating the pruning tables

#ifndef PRUNING_H
#define PRUNING_H

using namespace std;

// Check if the tree should be cut
bool prune(map<string, substate>& state, int depth, map<string, dataset>& datasets, map<string, subprune>& prunetables);

// Functions for generating complete pruning tables.
map<string, subprune> getCompletePruneTables(map<string, substate> solved, map<string, map<string, submove> > moves, map<string, dataset> datasets, map<string, substate> ignore, string filename);
vector<char> buildCompleteOrientationPruningTable(vector<int> solved, map<string, map<string, submove> > moves, string setname, int omod, vector<int> ignore);
vector<char> buildCompletePermutationPruningTable(vector<int> solved, map<string, map<string, submove> > moves, string setname, vector<int> ignore);
map<string, subprune> buildCompletePruneTables(map<string, substate> solved, map<string, map<string, submove> > moves, map<string, dataset> datasets, map<string, substate> ignore);
vector<char> buildCompletePermutationPruningTable3(vector<int> solved, map<string, map<string, submove> > moves, string setname, vector<int> ignore);


map<vector<long long>, char> buildPartialOrientationPruningTable(vector<int> solved, map<string, map<string, submove> > moves, string setname, int omod, vector<int> ignore);
map<vector<long long>, char> buildPartialPermutationPruningTable(vector<int> solved, map<string, map<string, submove> > moves, string setname, vector<int> ignore);


// Find the max depth in a partial table
int maxDepth( map< vector<long long>, char> table );

void updateDatasets(map<string, dataset> &datasets, map<string, subprune> &tables);

#endif
