
/*
 KSolve - Puzzle solving program.
 Copyright (C) 2007  Kre Krig

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <iostream>
#include <fstream>
#include <vector>
#include <cmath>  // Using log in some tests
#include <map>
#include "data.h"
#include "move.h"
#include "checks.h"
#include "pruning.h"
#include "indexing.h"

#define PROFILE_K
#ifdef PROFILE_K
#include <windows.h>
#endif

using namespace std;

map<string, subprune> getCompletePruneTables(map<string, substate> solved, map<string, map<string, submove> > moves, map<string, dataset> datasets, map<string, substate> ignore, string filename)
{
   map<string, subprune> table;
   filename += ".tables"; 
   ifstream fin;
//   fin.open(filename.c_str(), ios::in);
   fin.open(filename.c_str(), ios::in | ios::binary);
   
   if( fin.is_open() ){
      cout << "Pruning tables found on file." << endl;
      #ifdef PROFILE_K
         LARGE_INTEGER lFreq, lStart, lEnd;
         QueryPerformanceFrequency(&lFreq);
         QueryPerformanceCounter(&lStart);
      #endif
      
      // Tables exist
      int checksum;
      fin.read( (char*) (&checksum), sizeof(checksum) ); // Not used yet

      map<string, substate>::iterator iter;
      for(iter = solved.begin(); iter != solved.end(); iter++){

         if( factorial(datasets[ (*iter).first ].size) <= MAX_COMPLETE_PERMUTATION_TABLE_SIZE && factorial(datasets[ (*iter).first ].size) != -1 && uniquePermutation(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) ){ 
            // Complete tables, unique pieces
            char buff;

            // Read permutation table
            int tab_size = factorial(datasets[ (*iter).first ].size);
            table[ (*iter).first ].permutation.reserve(tab_size);

            char *tmp_buff = new char[tab_size+1];
            fin.get(tmp_buff, tab_size+1, 'A');
            for(int i = 0; i < tab_size; i++){
               table[ (*iter).first ].permutation.push_back( tmp_buff[i] );
            }
            delete tmp_buff;
               

/*            for(int i = 0; i < tab_size; i++){
               fin.read( (char*) (&buff), sizeof(buff) );
               table[ (*iter).first ].permutation.push_back(buff);
//               table[ (*iter).first ].permutation.push_back( fin.get() );
               }
            }*/
         }
         else if( combinations(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) <= MAX_COMPLETE_PERMUTATION_TABLE_SIZE && combinations(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) != -1 && !uniquePermutation(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) ){ 
            // Complete table, non-unique pieces
            char buff;
            int tab_size = combinations(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size);
            for(int i = 0; i < tab_size; i++){
               fin.read( (char*) (&buff), sizeof(buff) );
               table[ (*iter).first ].permutation.push_back(buff);
            }
         }
         else{
            // Partial table
            int elements, keysize;
            fin.read( (char*) (&elements), sizeof(elements) );
            fin.read( (char*) (&keysize), sizeof(keysize) );

            cout << "elements " << elements << endl;
            cout << "keysize " << keysize << endl;
            for(int i = 0; i < elements; i++){
               char depth;
               vector<long long> key;
               long long tmp;
               fin.read( (char*) (&depth), sizeof(depth) );
               key.clear();
               for(int j = 0; j < keysize; j++){
                  fin.read( (char*) (&tmp), sizeof(tmp) );
                  key.push_back(tmp);
               }
               table[ (*iter).first ].partialpermutation[ key ] = depth;
            }
            table[ (*iter).first ].partialpermutation_depth = maxDepth( table[ (*iter).first ].partialpermutation );
         }

         double osize = log( datasets[ (*iter).first ].omod ) * datasets[ (*iter).first ].size;
         if( osize < log(MAX_COMPLETE_ORIENTATION_TABLE_SIZE) ){ // Not to big tables. Using log to avoid overflow.
            char buff;
            long long num = 1;
            for(int t = 0; t < datasets[ (*iter).first ].size; t++)
               num *= datasets[ (*iter).first ].omod;

                table[ (*iter).first ].orientation.reserve(num);
    
                char *tmp_buff = new char[num+1];
                fin.get(tmp_buff, num+1, 'A');
                for(int i = 0; i < num; i++){
                   table[ (*iter).first ].orientation.push_back( tmp_buff[i] );
                }
                delete tmp_buff;

/*            for(int i = 0; i < num; i++){
               fin.read( (char*) (&buff), sizeof(buff) );
               table[ (*iter).first ].orientation.push_back(buff);
            }*/

         }   
         else{ // Partial orientation tables
            int elements, keysize;
            fin.read( (char*) (&elements), sizeof(elements) );
            fin.read( (char*) (&keysize), sizeof(keysize) );
            cout << "elements " << elements << endl;
            cout << "keysize " << keysize << endl;
            for(int i = 0; i < elements; i++){
               char depth;
               vector<long long> key;
               long long tmp;
               fin.read( (char*) (&depth), sizeof(depth) );
               key.clear();
               for(int j = 0; j < keysize; j++){
                  fin.read( (char*) (&tmp), sizeof(tmp) );
                  key.push_back(tmp);
               }
               table[ (*iter).first ].partialorientation[ key ] = depth;
            }
            table[ (*iter).first ].partialorientation_depth = maxDepth( table[ (*iter).first ].partialorientation );
         }
      }
      fin.close();
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lEnd);
         cout << "Loading time: " << double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart << endl;
      #endif
      
   }   
   else{
      cout << "Pruning tables not found on file, computing." << endl;
      #ifdef PROFILE_K
         LARGE_INTEGER lFreq, lStart, lEnd;
         QueryPerformanceFrequency(&lFreq);
         QueryPerformanceCounter(&lStart);
      #endif
      table = buildCompletePruneTables(solved, moves, datasets, ignore);
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lEnd);
         cout << "Computing time: " << double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart << endl;
         QueryPerformanceCounter(&lStart);
      #endif
      ofstream fout;
//      fout.open(filename.c_str(), ios::out);
      fout.open(filename.c_str(), ios::out | ios::binary);
      int checksum = 1; // Not used yet
//      fout << checksum << " " << endl;
      fout.write( (char*) (&checksum), sizeof(checksum) );
      map<string, substate>::iterator iter;
      for(iter = solved.begin(); iter != solved.end(); iter++){
         if( factorial(datasets[ (*iter).first ].size) <= MAX_COMPLETE_PERMUTATION_TABLE_SIZE && factorial(datasets[ (*iter).first ].size) != -1 && uniquePermutation(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) ){
//         if( (factorial(datasets[ (*iter).first ].size) <= MAX_COMPLETE_PERMUTATION_TABLE_SIZE || (huge && factorial(datasets[ (*iter).first ].size) <= MAX_HUGE_COMPLETE_PERMUTATION_TABLE_SIZE) )
//             && factorial(datasets[ (*iter).first ].size) != -1 && uniquePermutation(solved[ (*iter).first ].permutation) ){ 
            // Complete permutation table, unique pieces
//            int buff;

            // Write permutation table
            int tab_size = factorial( datasets[ (*iter).first ].size);
            for(int i = 0; i < tab_size; i++){
//               fout << table[ (*iter).first ].permutation[i] << " ";
               fout.write( (char*) (&table[ (*iter).first ].permutation[i]), sizeof(table[ (*iter).first ].permutation[i]) );
            }
         }
         else if( combinations(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) <= MAX_COMPLETE_PERMUTATION_TABLE_SIZE && combinations(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) != -1){
            // Complete permutation table, not unique pieces
            int tab_size = combinations(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size);
            for(int i = 0; i < tab_size; i++)
               fout.write( (char*) (&table[ (*iter).first ].permutation[i]), sizeof(table[ (*iter).first ].permutation[i]) );
//               fout << table[ (*iter).first ].permutation[i] << " ";
         }
         else{
            // Partial permutation table  
//            fout << table[ (*iter).first ].partialpermutation.size() << " "; // Table entries
            int tmp_size = table[ (*iter).first ].partialpermutation.size();
            fout.write( (char*) (&tmp_size), sizeof(tmp_size) );
            
            map< vector<long long>, char>::iterator tmp_iter;
            tmp_iter = table[ (*iter).first ].partialpermutation.begin();
//            fout << (*tmp_iter).first.size() << " " << endl; // Key size
            tmp_size = (*tmp_iter).first.size();
            fout.write( (char*) (&tmp_size), sizeof(tmp_size) );
            
            for( tmp_iter = table[ (*iter).first ].partialpermutation.begin() ; tmp_iter != table[ (*iter).first ].partialpermutation.end(); tmp_iter++){
//               fout << tmp_iter->second << " "; // Depth
               fout.write( (char*) (&tmp_iter->second), sizeof(tmp_iter->second) );
               for(int i = 0; i < (*tmp_iter).first.size(); i++)
                  fout.write( (char*) (&(*tmp_iter).first[i]), sizeof((*tmp_iter).first[i]) );
//                  fout << (*tmp_iter).first[i] << " "; // Keys
//               fout << endl;
            }
         }
//         fout << endl;

//         double osize = 0.0;
//         for(int t = 0; t < datasets[ (*iter).first ].size; t++)
//            osize += log( datasets[ (*iter).first ].omod );
         double osize = log( datasets[ (*iter).first ].omod ) * datasets[ (*iter).first ].size;

         if( osize < log(MAX_COMPLETE_ORIENTATION_TABLE_SIZE) ){ // Not to big tables. Using log to avoid overflow.
            for(int i = 0; i < table[ (*iter).first ].orientation.size(); i++){
//               fout << table[ (*iter).first ].orientation[i] << " ";
               fout.write( (char*) (&table[ (*iter).first ].orientation[i]), sizeof(table[ (*iter).first ].orientation[i]) );
            }
         }
         else{ // Partial orientation table
//            fout << table[ (*iter).first ].partialorientation.size() << " "; // Table entries
            int tmp_size = table[ (*iter).first ].partialorientation.size();
            fout.write( (char*) (&tmp_size), sizeof(tmp_size) );

            map< vector<long long>, char>::iterator tmp_iter;
            tmp_iter = table[ (*iter).first ].partialorientation.begin();
//            fout << (*tmp_iter).first.size() << " " << endl; // Key size
            tmp_size = (*tmp_iter).first.size();
            fout.write( (char*) (&tmp_size), sizeof(tmp_size) );
            
            for( tmp_iter = table[ (*iter).first ].partialorientation.begin() ; tmp_iter != table[ (*iter).first ].partialorientation.end(); tmp_iter++){
//               fout << tmp_iter->second << " "; // Depth
               fout.write( (char*) (&tmp_iter->second), sizeof(tmp_iter->second) );
               for(int i = 0; i < (*tmp_iter).first.size(); i++)
//                  fout << (*tmp_iter).first[i] << " "; // Keys
                  fout.write( (char*) (&(*tmp_iter).first[i]), sizeof((*tmp_iter).first[i]) );
//               fout << endl;
            }
         }
//         fout << endl;
      }
      fout.close();
      #ifdef PROFILE_K
         QueryPerformanceCounter(&lEnd);
         cout << "Writing time: " << double(lEnd.QuadPart - lStart.QuadPart) / lFreq.QuadPart << endl;
      #endif

   }
   return table;
}
            
map<string, subprune> buildCompletePruneTables(map<string, substate> solved, map<string, map<string, submove> > moves, map<string, dataset> datasets, map<string, substate> ignore)
{
   map<string, substate>::iterator iter, iter2;
   map<string, subprune> table;
   vector<int> tmp_ignore;
   for(iter = solved.begin(); iter != solved.end(); iter++){
      iter2 = ignore.find( (*iter).first );
      tmp_ignore.clear();
      if(iter2 != ignore.end())
         for(int i = 0; i < ignore[ (*iter).first ].size; i++)
            tmp_ignore.push_back( ignore[ (*iter).first ].permutation[i] );
         
      if( factorial(datasets[ (*iter).first ].size) <= MAX_COMPLETE_PERMUTATION_TABLE_SIZE && factorial(datasets[ (*iter).first ].size) != -1 && uniquePermutation(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) ){
         // Complete table, unique pieces
         vector<int> temp_perm;
         for(int i = 0; i < solved[ (*iter).first ].size; i++)
            temp_perm.push_back( solved[ (*iter).first ].permutation[i] );
         table[ (*iter).first ].permutation = buildCompletePermutationPruningTable( temp_perm, moves, (*iter).first, tmp_ignore );
      }
      else if( combinations(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) <= MAX_COMPLETE_PERMUTATION_TABLE_SIZE && combinations(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) != -1 && !uniquePermutation(solved[ (*iter).first ].permutation, solved[ (*iter).first ].size) ){
         // Complete table, not unique pieces
         vector<int> temp_perm;
         for(int i= 0; i < solved[ (*iter).first ].size; i++)
            temp_perm.push_back( solved[ (*iter).first ].permutation[i] );
         table[ (*iter).first ].permutation = buildCompletePermutationPruningTable3( temp_perm, moves, (*iter).first, tmp_ignore );
      }
      else{
         // Partial permutation table 
         vector<int> temp_perm;
         for(int i = 0; i < solved[ (*iter).first ].size; i++)
            temp_perm.push_back( solved[ (*iter).first ].permutation[i] );
         table[ (*iter).first ].partialpermutation = buildPartialPermutationPruningTable( temp_perm, moves, (*iter).first, tmp_ignore );
         table[ (*iter).first ].partialpermutation_depth = maxDepth( table[ (*iter).first ].partialpermutation );
      }

      tmp_ignore.clear();
      if(iter2 != ignore.end())
         for(int i = 0; i < ignore[ (*iter).first ].size; i++)
            tmp_ignore.push_back( ignore[ (*iter).first ].orientation[i] );
      double osize = log( datasets[ (*iter).first ].omod ) * datasets[ (*iter).first ].size;
      if( osize < log(MAX_COMPLETE_ORIENTATION_TABLE_SIZE) ){ // Not to big tables. Using log to avoid overflow.
         vector<int> temp_orient;
         for(int i = 0; i < solved[ (*iter).first ].size; i++)
            temp_orient.push_back( solved[ (*iter).first ].orientation[i] );
         table[ (*iter).first ].orientation = buildCompleteOrientationPruningTable( temp_orient , moves, (*iter).first, datasets[(*iter).first].omod, tmp_ignore );
      }
      else{
         vector<int> temp_orient;
         for(int i = 0; i < solved[ (*iter).first ].size; i++)
            temp_orient.push_back( solved[ (*iter).first ].orientation[i] );
         table[ (*iter).first ].partialorientation = buildPartialOrientationPruningTable( temp_orient, moves, (*iter).first, datasets[(*iter).first].omod, tmp_ignore );
         table[ (*iter).first ].partialorientation_depth = maxDepth( table[ (*iter).first ].partialorientation );
      }
   }
   return table;
}               

vector<char> buildCompleteOrientationPruningTable(vector<int> solved, map<string, map<string, submove> > moves, string setname, int omod, vector<int> ignore)
{
   cout << "Building pruning for " << setname << " orientation." << endl;
   vector<char> table;
   int vector_size = solved.size();
   map<string, map<string, submove> >::iterator iter;
   int tablesize = 1;
   for(int i = 0; i < solved.size(); i++)
      tablesize *= omod;  // tablesize := omod ^ solved.size() 
                          // checking for numbers getting to large might be smart
      
   table.resize( tablesize );
   for(int i = 0; i < tablesize; i++)
      table[i] = -1;
      
   cout << "tablesize " << tablesize << endl;

   table[ oVector2Index( solved, omod ) ] = 0; // Put solved position in table

   int len = 0;
   int c;
   do
   {
      c = 0;
      for(int p = 0; p < tablesize; p++){
         if(table[p] == len){
            for(iter = moves.begin(); iter != moves.end(); iter++){
               int q = oVector2Index( applySubmoveO( oIndex2Vector(p, vector_size, omod), iter->second[setname].orient, iter->second[setname].permute, iter->second[setname].size, omod), omod);
               if(table[q] == -1){
                  table[q] = len + 1;
                  c++;
               }
            }
         }     
      }
      len++;
      if(ignore.empty()) // Dont write if first pass
         cout << c << " positions at depth " << len << endl; 
   }while( c > 0 );
   
   if(!ignore.empty()){ // If some pieces are to be ignored, use first pass to generate all
                        // solved positions. Then generate the real table.
      c = 0;
      for(int i = 0; i < tablesize; i++){
         if(table[i] != -1){
            vector<int> tmp_o = oIndex2Vector(i, vector_size, omod);
            bool solved_pos = true;
            for(int j = 0; j < vector_size; j++)
               if( ignore[j] == 0 && tmp_o[j] != solved[j] )
                  solved_pos = false;
            if(solved_pos){
               table[i] = 0;
               c++;
            }
            else
               table[i] = -1;
         }
      }
      cout << c << " solved positions." << endl;
      
      int len = 0;
      int c;
      do
      {
         c = 0;
         for(int p = 0; p < tablesize; p++){
            if(table[p] == len){
               for(iter = moves.begin(); iter != moves.end(); iter++){
                  int q = oVector2Index( applySubmoveO( oIndex2Vector(p, vector_size, omod), iter->second[setname].orient, iter->second[setname].permute, iter->second[setname].size, omod), omod);
                  if(table[q] == -1){
                     table[q] = len + 1;
                     c++;
                  }
               }
            }
         }     
         len++;
         cout << c << " positions at depth " << len << endl; 
      }while( c > 0 );
   }
   
   return table;
}

// Complete table, unique pieces
vector<char> buildCompletePermutationPruningTable(vector<int> solved, map<string, map<string, submove> > moves, string setname, vector<int> ignore)
{
   cout << "Building pruning for " << setname << " permutation." << endl;
   vector<char> table;
   int vector_size = solved.size();
   map<string, map<string, submove> >::iterator iter;
   int tablesize = 1;
   tablesize = factorial( solved.size() );
   
   table.resize( tablesize );
   for(int i = 0; i < tablesize; i++)
      table[i] = -1;
      
   cout << "tablesize " << tablesize << endl;

   table[ pVector2Index( solved ) ] = 0; // Put solved position in table

   int len = 0;
   int c;
   do
   {
      c = 0;
      for(int p = 0; p < tablesize; p++){
         if(table[p] == len){
            for(iter = moves.begin(); iter != moves.end(); iter++){
               int q = pVector2Index( applySubmoveP( pIndex2Vector(p, vector_size), iter->second[setname].permute, iter->second[setname].size) );
               if(table[q] == -1){
                  table[q] = len + 1;
                  c++;
               }
            }
         }     
      }
      len++;
      if(ignore.empty())
         cout << c << " positions at depth " << len << endl;
      else
         cout << c << " positions in phase one, depth " << len << endl; 
   }while( c > 0 );

   if(!ignore.empty()){
      c = 0;
      for(int i = 0; i < tablesize; i++){
         if(table[i] != -1){
            vector<int> tmp_p = pIndex2Vector(i, vector_size);
            bool solved_pos = true;
            for(int j = 0; j < vector_size; j++)
               if( ignore[j] == 0 && tmp_p[j] != solved[j] )
                  solved_pos = false;
            if(solved_pos){
               table[i] = 0;
               c++;
            }
            else
               table[i] = -1;
         }
      }
      cout << c << " solved positions." << endl;
      int len = 0;
      int c;
      do
      {
         c = 0;
         for(int p = 0; p < tablesize; p++){
            if(table[p] == len){
               for(iter = moves.begin(); iter != moves.end(); iter++){
                  int q = pVector2Index( applySubmoveP( pIndex2Vector(p, vector_size), iter->second[setname].permute, iter->second[setname].size) );
                  if(table[q] == -1){
                     table[q] = len + 1;
                     c++;
                  }
               }
            }     
         }
         len++;
         cout << c << " positions at depth " << len << endl; 
      }while( c > 0 );
   }

   return table;
}

// Complete table, not unique pieces
vector<char> buildCompletePermutationPruningTable3(vector<int> solved, map<string, map<string, submove> > moves, string setname, vector<int> ignore)
{
   cout << "Building pruning for " << setname << " permutation" << endl;
   vector<char> table;
   int vector_size = solved.size();
   map<string, map<string, submove> >::iterator iter;
   int tablesize = combinations(solved);
      
   table.resize( tablesize );
   for(int i = 0; i < tablesize; i++)
      table[i] = -1;
      
   cout << "tablesize " << tablesize << endl;

   table[ pVector3Index( solved ) ] = 0; // Put solved position in table

   int len = 0;
   int c;
   do
   {
      c = 0;
      for(int p = 0; p < tablesize; p++){
         if(table[p] == len){
            for(iter = moves.begin(); iter != moves.end(); iter++){
// FIX, assumes that inverses to all moves are also one move
               int q = pVector3Index( applySubmoveP( pIndex3Vector(p, solved), iter->second[setname].permute, iter->second[setname].size) );
// FIX
               if(table[q] == -1){
                  table[q] = len + 1;
                  c++;
               }
            }
         }     
      }
      len++;
      if(ignore.empty())
         cout << c << " positions at depth " << len << endl; 
   }while( c > 0 );
   
   if(!ignore.empty()){
      c = 0;
      for(int i = 0; i < tablesize; i++){
         if(table[i] != -1){
            vector<int> tmp_p = pIndex3Vector(i, solved);
            bool solved_pos = true;
            for(int j = 0; j < vector_size; j++)
               if( ignore[j] == 0 && tmp_p[j] != solved[j] )
                  solved_pos = false;
            if(solved_pos){
               table[i] = 0;
               c++;
            }
            else
               table[i] = -1;
         }
      }
      cout << c << " solved positions." << endl;

      int len = 0;
      int c;
      do
      {
         c = 0;
         for(int p = 0; p < tablesize; p++){
            if(table[p] == len){
               for(iter = moves.begin(); iter != moves.end(); iter++){
   // FIX, assumes that inverses to all moves are also one move
                  int q = pVector3Index( applySubmoveP( pIndex3Vector(p, solved), iter->second[setname].permute, iter->second[setname].size) );
   // FIX
                  if(table[q] == -1){
                     table[q] = len + 1;
                     c++;
                  }
               }
            }     
         }
         len++;
         cout << c << " positions at depth " << len << endl; 
      }while( c > 0 );

   }
   return table;
}

map<vector<long long>, char> buildPartialOrientationPruningTable(vector<int> solved, map<string, map<string, submove> > moves, string setname, int omod, vector<int> ignore)
{
   cout << "Building partial pruning table for " << setname << " orientation." << endl;
   map<vector<long long>, char> table;
   map<vector<long long>, char> old_table;
   map<vector<long long>, char>::iterator iter2, iter3;
   map<string, map<string, submove> >::iterator iter;
   int tablesize = 1;

   table[ packVector(solved) ] = 0; // Put solved position in table

   int len = 0;
   int c, tot_c;
   tot_c = 0;
   bool abort = false;

   do
   {
      c = 0;
      for(iter2 = table.begin(); iter2 != table.end(); iter++){
         if(iter2->second == len && !abort ){
            for(iter = moves.begin(); iter != moves.end(); iter++){
               vector<int> pos = unpackVector( (*iter2).first );
               vector<int> q = applySubmoveO( pos, iter->second[setname].orient, iter->second[setname].permute, iter->second[setname].size, omod);
               vector<long long> newpos = packVector(q);
               if( table.find(newpos) == table.end() ){
                  table[newpos] = len + 1;
                  c++;
                  tot_c++;
                  if(tot_c >= MAX_PARTIAL_ORIENTATION_TABLE_SIZE){
                     abort = true;
                     break;
                  }
               }
            }
         }
      }
      if(!abort)
         old_table = table;
      len++;
      cout << c << " positions at depth " << len << endl; 
         
   }while( c > 0 && !abort );
   if(abort){
      cout << "To many positions at depth " << len << ", removing." << endl;
      return old_table;
   }
      
   return table;
}


map<vector<long long>, char> buildPartialPermutationPruningTable(vector<int> solved, map<string, map<string, submove> > moves, string setname, vector<int> ignore)
{
   cout << "Building partial pruning for " << setname << " permutation." << endl;
   map< vector<long long>, char> table;
   map< vector<long long>, char> old_table;

   map< vector<long long>, char>::iterator iter2;
   map<string, map<string, submove> >::iterator iter;

   vector<long long> first_key = packVector( solved );
   table[ first_key ] = 0; // Put solved position in table

   if( !ignore.empty() ){
      vector<int> repermutation;
      vector<int> first_perm;
      for( int i = 0; i < ignore.size(); i++)
         if( ignore[i] == 1 )
            repermutation.push_back( i );
      if( repermutation.size() > 8 ){
         cout << "Cant ignore permutation of more than 8 pieces in a big set." << endl;
         cout << "Set: " << setname << endl;
         exit(-1);
      }
      while( next_permutation( repermutation.begin(), repermutation.end() ) ){
         vector<int> tmp_perm;
         tmp_perm = solved;
         int v = 0;
         
         for(int i = 0; i < solved.size(); i++){
            if( ignore[i] == 1 ){
               tmp_perm[ i ] = solved[ repermutation[v] ];
               v++;
            }
         }
         table[ packVector(tmp_perm) ] = 0;
      }
      cout << table.size() << " solved positions." << endl;
   }

   int len = 0;
   int c, tot_c;
   tot_c = 0;
   bool abort = false;
   do
   {
      c = 0;
      for(iter2 = table.begin(); iter2 != table.end(); iter2++){
         if(iter2->second == len && !abort){
            for(iter = moves.begin(); iter != moves.end(); iter++){
               vector<int> pos = unpackVector( (*iter2).first );
//               cout << "ping" << endl;
               vector<int> q = applySubmoveP( pos , iter->second[setname].permute, iter->second[setname].size);
//               cout << "pong" << endl;
               vector<long long> newpos = packVector(q);
               if(table.find(newpos) == table.end() ){
                  table[newpos] = len + 1;
                  c++;
                  tot_c++;
                  if(tot_c >= MAX_PARTIAL_PERMUTATION_TABLE_SIZE){
                     abort = true;
                     break;
                  }
               }
            }
         }     
      }
      if(!abort)
         old_table = table;
      len++;
      cout << c << " positions at depth " << len << endl;
   }while( c > 0 && !abort);
   
   if(abort){
      cout << "To many positions at depth " << len << ", removing." << endl;
      return old_table;
   }

   return table;
}

int maxDepth( map< vector<long long>, char> table ){
   int maxdepth = 0;
   map< vector<long long>, char>::iterator iter;
   for(iter = table.begin(); iter != table.end(); iter++)
      if( maxdepth < iter->second )
         maxdepth = iter->second;                
   return maxdepth;      
}

// Function checks the tables and assign flags accordingly
void updateDatasets(map<string, dataset> &datasets, map<string, subprune> &tables)
{
   map<string, subprune>::iterator iter = tables.begin();
   for(;iter != tables.end(); iter++){
/*      if( iter->second.permutation.size() < 1 )
         datasets[ (*iter).first ].ptabletype = TABLE_TYPE_NONE;
      else if( factorial(datasets[ (*iter).first ].size) <= MAX_COMPLETE_PERMUTATION_TABLE_SIZE )
         datasets[ (*iter).first ].ptabletype = TABLE_TYPE_COMPLETE;
      else
         datasets[ (*iter).first ].ptabletype = TABLE_TYPE_PARTIAL;*/
      if( iter->second.permutation.size() >= 1 )
         datasets[ (*iter).first ].ptabletype = TABLE_TYPE_COMPLETE;
      else if( iter->second.partialpermutation.size() >= 1)
         datasets[ (*iter).first ].ptabletype = TABLE_TYPE_PARTIAL;
      else
         datasets[ (*iter).first ].ptabletype = TABLE_TYPE_NONE;

      double tablesize = 1.0;
      for(int i = 0; i < datasets[ (*iter).first ].size; i++)
         tablesize *= datasets[ (*iter).first ].omod;  // tablesize := omod ^ solved.size() 
                             // checking for numbers getting to large might be smart
      if( iter->second.orientation.size() < 1 )
         datasets[ (*iter).first ].otabletype = TABLE_TYPE_NONE;
      else if( tablesize <= MAX_COMPLETE_ORIENTATION_TABLE_SIZE )
         datasets[ (*iter).first ].otabletype = TABLE_TYPE_COMPLETE;
      else
         datasets[ (*iter).first ].otabletype = TABLE_TYPE_PARTIAL;
   }
}

bool prune(map<string, substate>& state, int depth, map<string, dataset>& datasets, map<string, subprune>& prunetables){
   map<string, substate>::iterator iter2;
   for(iter2 = state.begin(); iter2 != state.end(); iter2++){

      // Orientation pruning
      if( datasets[ (*iter2).first ].otabletype == TABLE_TYPE_COMPLETE ){
         int index = oVector2Index(iter2->second.orientation, iter2->second.size, datasets[(*iter2).first].omod);
         if( prunetables[ (*iter2).first ].orientation[ index ]  > depth ){
            return true;
         }
      }
      else if( datasets[ (*iter2).first ].otabletype == TABLE_TYPE_PARTIAL ){
         vector<long long> index = packVector(iter2->second.orientation, iter2->second.size);
         
         if( prunetables[ (*iter2).first ].partialorientation_depth >= depth ){
            if( prunetables[ (*iter2).first ].partialorientation.count( index ) == 1){ // If the position exist in the table then...
               if( prunetables[ (*iter2).first ].partialorientation[ index ] > depth ){
                  return true;
               }                   
            }
            else{
               return true;
            }
         }
      }
      // Permutation pruning
      if( (datasets[ (*iter2).first ].ptabletype == TABLE_TYPE_COMPLETE) && datasets[ (*iter2).first ].uniqueperm ){
//         vector<int> tmpvec2 = iter2->second.permutation;
         int index = pVector2Index(iter2->second.permutation, iter2->second.size);
         if( prunetables[ (*iter2).first ].permutation[ index ]  > depth ){
            return true;
         }
      }
      else if( (datasets[ (*iter2).first ].ptabletype == TABLE_TYPE_COMPLETE) && !datasets[ (*iter2).first ].uniqueperm ){
//         vector<int> tmpvec2 = iter2->second.permutation;
         long long index = pVector3Index(iter2->second.permutation, iter2->second.size);
         if( prunetables[ (*iter2).first ].permutation[ index ]  > depth ){
            return true;
         }
      }
      else if( datasets[ (*iter2).first ].ptabletype == TABLE_TYPE_PARTIAL ){
//         vector<int> tmpvec2 = iter2->second.permutation;
         vector<long long> index = packVector(iter2->second.permutation, iter2->second.size);

         if( prunetables[ (*iter2).first ].partialpermutation_depth >= depth ){
            if( prunetables[ (*iter2).first ].partialpermutation.find( index ) != prunetables[ (*iter2).first ].partialpermutation.end() ){
               if( prunetables[ (*iter2).first ].partialpermutation[ index ] > depth ){
                  return true;
               }
            }
            else{
               return true;
            }
         }
      }
   }
   return false;
}
