/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ScrambleGenerator
extends JFrame
implements ActionListener {
    JButton generateButton;
    JComboBox cubeCombo;
    JLabel cubeLabel;
    JLabel numLabel;
    JTextField numText;
    JRadioButton formatPrint;
    JRadioButton formatImport;
    ButtonGroup radioGroup;
    ScrambleAlgorithm algGenerator;

    public ScrambleGenerator() {
        Container container = this.getContentPane();
        container.setLayout(null);
        this.algGenerator = new ScrambleAlgorithm();
        this.setTitle("Scramble Generator");
        this.setSize(260, 150);
        this.setIconImage(new ImageIcon(this.getClass().getResource("Cow.gif")).getImage());
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        this.cubeLabel = new JLabel("Cube Type");
        this.numLabel = new JLabel("Number of Scrambles");
        String[] stringArray = new String[]{"2x2x2", "3x3x3", "4x4x4", "5x5x5", "Pyraminx"};
        this.cubeCombo = new JComboBox<String>(stringArray);
        this.cubeCombo.setSelectedIndex(1);
        this.numText = new JTextField("13");
        this.generateButton = new JButton("Generate Scrambles");
        this.generateButton.addActionListener(this);
        this.formatPrint = new JRadioButton("Format Output For Printing");
        this.formatImport = new JRadioButton("Format Output For Importing");
        this.radioGroup = new ButtonGroup();
        this.cubeLabel.setBounds(10, 5, 82, 20);
        this.numLabel.setBounds(102, 5, 141, 20);
        this.cubeCombo.setBounds(10, 25, 82, 20);
        this.numText.setBounds(102, 25, 141, 20);
        this.formatPrint.setBounds(10, 50, 233, 20);
        this.formatImport.setBounds(10, 70, 233, 20);
        this.generateButton.setBounds(10, 95, 233, 20);
        container.add(this.cubeLabel);
        container.add(this.numLabel);
        container.add(this.cubeCombo);
        container.add(this.numText);
        container.add(this.generateButton);
        container.add(this.formatPrint);
        container.add(this.formatImport);
        this.radioGroup.add(this.formatPrint);
        this.radioGroup.add(this.formatImport);
        this.formatPrint.setSelected(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.generateButton) {
            int n;
            int n2 = 0;
            try {
                n2 = Integer.parseInt(this.numText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Number of scrambles is invalid. Please enter an integer to continue.");
                return;
            }
            if (n2 < 1) {
                JOptionPane.showMessageDialog(this, "Number of scrambles is invalid. Please enter an integer to continue.");
                return;
            }
            String string = "";
            if (this.formatPrint.isSelected()) {
                string = "----- JNetCube Generated Scrambles -----\r\n\r\nCube Type: " + this.cubeCombo.getSelectedItem() + "\r\nNumber of Scrambles: " + n2 + "\r\n\r\nScrambles:\r\n";
                for (n = 0; n < n2; ++n) {
                    string = string + (n + 1) + ")          " + this.algGenerator.generateAlg(this.cubeCombo.getSelectedItem() + "") + "\r\n";
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    string = string + this.algGenerator.generateAlg(this.cubeCombo.getSelectedItem() + "") + "\r\n";
                }
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new TextFileFilter());
            jFileChooser.setAcceptAllFileFilterUsed(false);
            int n3 = jFileChooser.showSaveDialog(this);
            if (n3 == 0) {
                try {
                    FileWriter fileWriter = new FileWriter(new File(jFileChooser.getSelectedFile() + ".txt"));
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(string);
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "There was an error saving. You may not have write permissions.");
                }
            }
        }
    }
}

