/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public final class AnimCube
extends Applet
implements Runnable,
MouseListener,
MouseMotionListener {
    private final Hashtable config = new Hashtable();
    private Color bgColor;
    private Color bgColor2;
    private Color hlColor;
    private Color textColor;
    private Color buttonBgColor;
    private final Color[] colors = new Color[24];
    private final int[][] cube = new int[6][9];
    private final int[][] initialCube = new int[6][9];
    private static final double[][] faceNormals = new double[][]{{0.0, -1.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}, {0.0, 0.0, 1.0}, {-1.0, 0.0, 0.0}, {1.0, 0.0, 0.0}};
    private static final double[][] cornerCoords = new double[][]{{-1.0, -1.0, -1.0}, {1.0, -1.0, -1.0}, {1.0, -1.0, 1.0}, {-1.0, -1.0, 1.0}, {-1.0, 1.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, 1.0, 1.0}, {-1.0, 1.0, 1.0}};
    private static final int[][] faceCorners = new int[][]{{0, 1, 2, 3}, {4, 7, 6, 5}, {0, 4, 5, 1}, {2, 6, 7, 3}, {0, 3, 7, 4}, {1, 5, 6, 2}};
    private static final int[][] oppositeCorners = new int[][]{{0, 3, 2, 1}, {0, 3, 2, 1}, {3, 2, 1, 0}, {3, 2, 1, 0}, {0, 3, 2, 1}, {0, 3, 2, 1}};
    private static final int[][] adjacentFaces = new int[][]{{2, 5, 3, 4}, {4, 3, 5, 2}, {4, 1, 5, 0}, {5, 1, 4, 0}, {0, 3, 1, 2}, {2, 1, 3, 0}};
    private int twistedLayer;
    private int twistedMode;
    private static final int[] faceTwistDirs = new int[]{1, 1, -1, -1, -1, -1};
    private final double[] eye = new double[]{0.0, 0.0, -1.0};
    private final double[] eyeX = new double[]{1.0, 0.0, 0.0};
    private final double[] eyeY = new double[3];
    private final double[] initialEye = new double[3];
    private final double[] initialEyeX = new double[3];
    private final double[] initialEyeY = new double[3];
    private double currentAngle;
    private double originalAngle;
    private int speed;
    private int doubleSpeed;
    private boolean natural = true;
    private boolean toTwist;
    private boolean interrupted;
    private boolean restarted;
    private boolean mirrored;
    private boolean editable;
    private boolean twisting;
    private boolean spinning;
    private boolean animating;
    private boolean dragging;
    private boolean demo;
    private int persp;
    private double scale;
    private int align;
    private boolean hint;
    private double faceShift;
    private int[][] move;
    private int[][] demoMove;
    private int curMove;
    private int movePos;
    private int moveDir;
    private boolean moveOne;
    private boolean moveAnimated;
    private int metric;
    private String[] infoText;
    private int curInfoText;
    private int buttonBar;
    private int buttonHeight;
    private boolean drawButtons = true;
    private boolean pushed;
    private int buttonPressed = -1;
    private int progressHeight = 6;
    private int textHeight;
    private int moveText;
    private boolean outlined = true;
    private static final int[] posFaceTransform = new int[]{3, 2, 0, 5, 1, 4};
    private static final int[][] posFaceletTransform = new int[][]{{6, 3, 0, 7, 4, 1, 8, 5, 2}, {2, 5, 8, 1, 4, 7, 0, 3, 6}, {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}, {6, 3, 0, 7, 4, 1, 8, 5, 2}, {0, 1, 2, 3, 4, 5, 6, 7, 8}};
    private final int[] hex = new int[6];
    private static final int[] moveModes = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2};
    private static final int[] moveCodes = new int[]{0, 1, 2, 3, 4, 5, 1, 2, 4, 5, 2, 0, 5, 2, 0, 0, 1, 2, 3, 4, 5};
    private static final char[] modeChar = new char[]{'m', 't', 'c', 's', 'a'};
    private static final String[][][] turnSymbol = new String[][][]{{{"U", "D", "F", "B", "L", "R"}, {"Um", "Dm", "Fm", "Bm", "Lm", "Rm"}, {"Ut", "Dt", "Ft", "Bt", "Lt", "Rt"}, {"Uc", "Dc", "Fc", "Bc", "Lc", "Rc"}, {"Us", "Ds", "Fs", "Bs", "Ls", "Rs"}, {"Ua", "Da", "Fa", "Ba", "La", "Ra"}}, {{"U", "D", "F", "B", "L", "R"}, {"~E", "E", "S", "~S", "M", "~M"}, {"u", "d", "f", "b", "l", "r"}, {"Z", "~Z", "Y", "~Y", "~X", "X"}, {"Us", "Ds", "Fs", "Bs", "Ls", "Rs"}, {"Ua", "Da", "Fa", "Ba", "La", "Ra"}}, {{"U", "D", "F", "B", "L", "R"}, {"~E", "E", "S", "~S", "M", "~M"}, {"u", "d", "f", "b", "l", "r"}, {"Y", "~Y", "Z", "~Z", "~X", "X"}, {"Us", "Ds", "Fs", "Bs", "Ls", "Rs"}, {"Ua", "Da", "Fa", "Ba", "La", "Ra"}}, {{"U", "D", "F", "B", "L", "R"}, {"u", "d", "f", "b", "l", "r"}, {"Uu", "Dd", "Ff", "Bb", "Ll", "Rr"}, {"QU", "QD", "QF", "QB", "QL", "QR"}, {"UD'", "DU'", "FB'", "BF'", "LR'", "RL'"}, {"UD", "DU", "FB", "BF", "LR", "RL"}}};
    private static final String[] modifierStrings = new String[]{"", "2", "'", "2'"};
    private static final String[] metricChar = new String[]{"", "q", "f", "s"};
    private Thread animThread = null;
    private static final int[][][] cubeBlocks = new int[][][]{new int[][]{{0, 3}, {0, 3}}, new int[][]{{0, 3}, {0, 3}}, new int[][]{{0, 3}, {0, 3}}, new int[][]{{0, 3}, {0, 3}}, new int[][]{{0, 3}, {0, 3}}, new int[][]{{0, 3}, {0, 3}}};
    private final int[][][] topBlocks = new int[6][][];
    private final int[][][] midBlocks = new int[6][][];
    private final int[][][] botBlocks = new int[6][][];
    private static final int[][][] topBlockTable = new int[][][]{new int[][]{{0, 0}, {0, 0}}, new int[][]{{0, 3}, {0, 3}}, new int[][]{{0, 3}, {0, 1}}, new int[][]{{0, 1}, {0, 3}}, new int[][]{{0, 3}, {2, 3}}, new int[][]{{2, 3}, {0, 3}}};
    private static final int[][][] midBlockTable = new int[][][]{new int[][]{{0, 0}, {0, 0}}, new int[][]{{0, 3}, {1, 2}}, new int[][]{{1, 2}, {0, 3}}};
    private static final int[][] topBlockFaceDim = new int[][]{{1, 0, 3, 3, 2, 3}, {0, 1, 5, 5, 4, 5}, {2, 3, 1, 0, 3, 2}, {4, 5, 0, 1, 5, 4}, {3, 2, 2, 4, 1, 0}, {5, 4, 4, 2, 0, 1}};
    private static final int[][] midBlockFaceDim = new int[][]{{0, 0, 2, 2, 1, 2}, {0, 0, 2, 2, 1, 2}, {1, 2, 0, 0, 2, 1}, {1, 2, 0, 0, 2, 1}, {2, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 0, 0}};
    private static final int[][] botBlockFaceDim = new int[][]{{0, 1, 5, 5, 4, 5}, {1, 0, 3, 3, 2, 3}, {4, 5, 0, 1, 5, 4}, {2, 3, 1, 0, 3, 2}, {5, 4, 4, 2, 0, 1}, {3, 2, 2, 4, 1, 0}};
    private static final int[] cycleOrder = new int[]{0, 1, 2, 5, 8, 7, 6, 3};
    private static final int[] cycleFactors = new int[]{1, 3, -1, -3, 1, 3, -1, -3};
    private static final int[] cycleOffsets = new int[]{0, 2, 8, 6, 3, 1, 5, 7};
    private static final int[][] cycleLayerSides = new int[][]{{3, 3, 3, 0}, {2, 1, 1, 1}, {3, 3, 0, 0}, {2, 1, 1, 2}, {3, 2, 0, 0}, {2, 2, 0, 1}};
    private static final int[][] cycleCenters = new int[][]{{7, 7, 7, 4}, {6, 5, 5, 5}, {7, 7, 4, 4}, {6, 5, 5, 6}, {7, 6, 4, 4}, {6, 6, 4, 5}};
    private final int[] twistBuffer = new int[12];
    private Graphics graphics = null;
    private Image image = null;
    private int width;
    private int height;
    private int lastX;
    private int lastY;
    private int lastDragX;
    private int lastDragY;
    private int dragAreas;
    private final int[][] dragCornersX = new int[18][4];
    private final int[][] dragCornersY = new int[18][4];
    private final double[] dragDirsX = new double[18];
    private final double[] dragDirsY = new double[18];
    private static final int[][][] dragBlocks = new int[][][]{new int[][]{{0, 0}, {3, 0}, {3, 1}, {0, 1}}, new int[][]{{3, 0}, {3, 3}, {2, 3}, {2, 0}}, new int[][]{{3, 3}, {0, 3}, {0, 2}, {3, 2}}, new int[][]{{0, 3}, {0, 0}, {1, 0}, {1, 3}}, new int[][]{{0, 1}, {3, 1}, {3, 2}, {0, 2}}, new int[][]{{2, 0}, {2, 3}, {1, 3}, {1, 0}}};
    private static final int[][] areaDirs = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}, {1, 0}, {0, 1}};
    private static final int[][] twistDirs = new int[][]{{1, 1, 1, 1, 1, -1}, {1, 1, 1, 1, 1, -1}, {1, -1, 1, -1, 1, 1}, {1, -1, 1, -1, -1, 1}, {-1, 1, -1, 1, -1, -1}, {1, -1, 1, -1, 1, 1}};
    private int[] dragLayers = new int[18];
    private int[] dragModes = new int[18];
    private double dragX;
    private double dragY;
    private static final int[][][] rotCos = new int[][][]{new int[][]{{1, 0, 0}, {0, 0, 0}, {0, 0, 1}}, new int[][]{{1, 0, 0}, {0, 1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 1}}};
    private static final int[][][] rotSin = new int[][][]{new int[][]{{0, 0, 1}, {0, 0, 0}, {-1, 0, 0}}, new int[][]{{0, 1, 0}, {-1, 0, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 1}, {0, -1, 0}}};
    private static final int[][][] rotVec = new int[][][]{new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}, new int[][]{{1, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
    private static final int[] rotSign = new int[]{1, -1, 1, -1, 1, -1};
    private final double[] tempEye = new double[3];
    private final double[] tempEyeX = new double[3];
    private final double[] tempEyeY = new double[3];
    private final double[] tempEye2 = new double[3];
    private final double[] tempEyeX2 = new double[3];
    private final double[] tempEyeY2 = new double[3];
    private final double[] perspEye = new double[3];
    private final double[] perspEyeI = new double[3];
    private final double[] perspNormal = new double[3];
    private final double[][] eyeArray = new double[3][];
    private final double[][] eyeArrayX = new double[3][];
    private final double[][] eyeArrayY = new double[3][];
    private final int[][] eyeOrder = new int[][]{{1, 0, 0}, {0, 1, 0}, {1, 1, 0}, {1, 1, 1}, {1, 0, 1}, {1, 0, 2}};
    private final int[][][][] blockArray = new int[3][][][];
    private final int[][] blockMode = new int[][]{{0, 2, 2}, {2, 1, 2}, {2, 2, 2}, {2, 2, 2}, {2, 2, 2}, {2, 2, 2}};
    private final int[][] drawOrder = new int[][]{{0, 1, 2}, {2, 1, 0}, {0, 2, 1}};
    private final int[] fillX = new int[4];
    private final int[] fillY = new int[4];
    private final double[] coordsX = new double[8];
    private final double[] coordsY = new double[8];
    private final double[][] cooX = new double[6][4];
    private final double[][] cooY = new double[6][4];
    private static final double[][] border = new double[][]{{0.1, 0.1}, {0.9, 0.1}, {0.9, 0.9}, {0.1, 0.9}};
    private static final int[][] factors = new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}};
    private final double[] faceShiftX = new double[6];
    private final double[] faceShiftY = new double[6];
    private final double[] tempNormal = new double[3];
    private static final int[] textOffset = new int[]{1, 1, -1, -1, -1, 1, 1, -1, -1, 0, 1, 0, 0, 1, 0, -1};
    private static final int[] buttonAction = new int[]{-1, 3, 1, -1, 0, 2, 4, -1};
    private final double[] eyeD = new double[3];
    private static final String[] buttonDescriptions = new String[]{"Clear to the initial state", "Show the previous step", "Play backward", "Stop", "Play", "Show the next step", "Go to the end", "Next sequence"};
    private String buttonDescription = "";

    public void init() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.colors[0] = new Color(255, 128, 64);
        this.colors[1] = new Color(255, 0, 0);
        this.colors[2] = new Color(0, 255, 0);
        this.colors[3] = new Color(0, 0, 255);
        this.colors[4] = new Color(153, 153, 153);
        this.colors[5] = new Color(170, 170, 68);
        this.colors[6] = new Color(187, 119, 68);
        this.colors[7] = new Color(153, 68, 68);
        this.colors[8] = new Color(68, 119, 68);
        this.colors[9] = new Color(0, 68, 119);
        this.colors[10] = new Color(255, 255, 255);
        this.colors[11] = new Color(255, 255, 0);
        this.colors[12] = new Color(255, 96, 32);
        this.colors[13] = new Color(208, 0, 0);
        this.colors[14] = new Color(0, 144, 0);
        this.colors[15] = new Color(32, 64, 208);
        this.colors[16] = new Color(176, 176, 176);
        this.colors[17] = new Color(80, 80, 80);
        this.colors[18] = new Color(255, 0, 255);
        this.colors[19] = new Color(0, 255, 255);
        this.colors[20] = new Color(255, 160, 192);
        this.colors[21] = new Color(32, 255, 16);
        this.colors[22] = new Color(0, 0, 0);
        this.colors[23] = new Color(128, 128, 128);
        this.animThread = new Thread((Runnable)this, "Cube Animator");
        this.animThread.start();
        Object object2 = this.getParameter("config");
        if (object2 != null) {
            try {
                URL uRL = new URL(this.getDocumentBase(), (String)object2);
                InputStream inputStream = uRL.openStream();
                object = new BufferedReader(new InputStreamReader(inputStream));
                String string = ((BufferedReader)object).readLine();
                while (string != null) {
                    n5 = string.indexOf(61);
                    if (n5 > 0) {
                        String string2 = string.substring(0, n5).trim();
                        String string3 = string.substring(n5 + 1).trim();
                        this.config.put(string2, string3);
                    }
                    string = ((BufferedReader)object).readLine();
                }
                ((BufferedReader)object).close();
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Malformed URL: " + (String)object2 + ": " + malformedURLException);
            }
            catch (IOException iOException) {
                System.err.println("Input error: " + (String)object2 + ": " + iOException);
            }
        }
        if ((object2 = this.getParameter("bgcolor")) != null && ((String)object2).length() == 6) {
            int n6 = 0;
            while (n6 < 6) {
                int n7 = 0;
                while (n7 < 16) {
                    if (Character.toLowerCase(((String)object2).charAt(n6)) == "0123456789abcdef".charAt(n7)) {
                        this.hex[n6] = n7;
                        break;
                    }
                    ++n7;
                }
                ++n6;
            }
            this.bgColor = new Color(this.hex[0] * 16 + this.hex[1], this.hex[2] * 16 + this.hex[3], this.hex[4] * 16 + this.hex[5]);
        } else {
            this.bgColor = Color.gray;
        }
        object2 = this.getParameter("butbgcolor");
        if (object2 != null && ((String)object2).length() == 6) {
            int n8 = 0;
            while (n8 < 6) {
                int n9 = 0;
                while (n9 < 16) {
                    if (Character.toLowerCase(((String)object2).charAt(n8)) == "0123456789abcdef".charAt(n9)) {
                        this.hex[n8] = n9;
                        break;
                    }
                    ++n9;
                }
                ++n8;
            }
            this.buttonBgColor = new Color(this.hex[0] * 16 + this.hex[1], this.hex[2] * 16 + this.hex[3], this.hex[4] * 16 + this.hex[5]);
        } else {
            this.buttonBgColor = this.bgColor;
        }
        object2 = this.getParameter("colors");
        if (object2 != null) {
            int n10 = 0;
            while (n10 < 10 && n10 < ((String)object2).length() / 6) {
                int n11 = 0;
                while (n11 < 6) {
                    int n12 = 0;
                    while (n12 < 16) {
                        if (Character.toLowerCase(((String)object2).charAt(n10 * 6 + n11)) == "0123456789abcdef".charAt(n12)) {
                            this.hex[n11] = n12;
                            break;
                        }
                        ++n12;
                    }
                    ++n11;
                }
                this.colors[n10] = new Color(this.hex[0] * 16 + this.hex[1], this.hex[2] * 16 + this.hex[3], this.hex[4] * 16 + this.hex[5]);
                ++n10;
            }
        }
        int n13 = 0;
        while (n13 < 6) {
            int n14 = 0;
            while (n14 < 9) {
                this.cube[n13][n14] = n13 + 10;
                ++n14;
            }
            ++n13;
        }
        object = "lluu";
        object2 = this.getParameter("colorscheme");
        if (object2 != null && ((String)object2).length() == 6) {
            int n15 = 0;
            while (n15 < 6) {
                n5 = 23;
                int n16 = 0;
                while (n16 < 23) {
                    if (Character.toLowerCase(((String)object2).charAt(n15)) == "0123456789wyorgbldmcpnk".charAt(n16)) {
                        n5 = n16;
                        break;
                    }
                    ++n16;
                }
                int n17 = 0;
                while (n17 < 9) {
                    this.cube[n15][n17] = n5;
                    ++n17;
                }
                ++n15;
            }
        }
        if ((object2 = this.getParameter("pos")) != null && ((String)object2).length() == 54) {
            object = "uuuuff";
            if (this.bgColor == Color.gray) {
                this.bgColor = Color.white;
            }
            int n18 = 0;
            while (n18 < 6) {
                n5 = posFaceTransform[n18];
                int n19 = 0;
                while (n19 < 9) {
                    int n20 = posFaceletTransform[n18][n19];
                    this.cube[n5][n20] = 23;
                    n4 = 0;
                    while (n4 < 14) {
                        if (((String)object2).charAt(n18 * 9 + n19) == "DFECABdfecabgh".charAt(n4)) {
                            this.cube[n5][n20] = n4 + 4;
                            break;
                        }
                        ++n4;
                    }
                    ++n19;
                }
                ++n18;
            }
        }
        if ((object2 = this.getParameter("facelets")) != null && ((String)object2).length() == 54) {
            int n21 = 0;
            while (n21 < 6) {
                n5 = 0;
                while (n5 < 9) {
                    this.cube[n21][n5] = 23;
                    int n22 = 0;
                    while (n22 < 23) {
                        if (Character.toLowerCase(((String)object2).charAt(n21 * 9 + n5)) == "0123456789wyorgbldmcpnk".charAt(n22)) {
                            this.cube[n21][n5] = n22;
                            break;
                        }
                        ++n22;
                    }
                    ++n5;
                }
                ++n21;
            }
        }
        this.move = (object2 = this.getParameter("move")) == null ? new int[0][0] : this.getMove((String)object2, true);
        this.movePos = 0;
        this.curInfoText = -1;
        object2 = this.getParameter("initmove");
        if (object2 != null) {
            int[][] nArray;
            int[][] nArray2 = nArray = ((String)object2).equals("#") ? this.move : this.getMove((String)object2, false);
            if (nArray.length > 0) {
                this.doMove(this.cube, nArray[0], 0, nArray[0].length, false);
            }
        }
        if ((object2 = this.getParameter("initrevmove")) != null) {
            int[][] nArray;
            int[][] nArray3 = nArray = ((String)object2).equals("#") ? this.move : this.getMove((String)object2, false);
            if (nArray.length > 0) {
                this.doMove(this.cube, nArray[0], 0, nArray[0].length, true);
            }
        }
        if ((object2 = this.getParameter("demo")) != null) {
            int[][] nArray = this.demoMove = ((String)object2).equals("#") ? this.move : this.getMove((String)object2, true);
            if (this.demoMove.length > 0 && this.demoMove[0].length > 0) {
                this.demo = true;
            }
        }
        object2 = this.getParameter("position");
        AnimCube.vNorm(AnimCube.vMul(this.eyeY, this.eye, this.eyeX));
        if (object2 == null) {
            object2 = object;
        }
        double d = 0.2617993877991494;
        int n23 = 0;
        while (n23 < ((String)object2).length()) {
            double d2 = d;
            switch (Character.toLowerCase(((String)object2).charAt(n23))) {
                case 'd': {
                    d2 = -d2;
                }
                case 'u': {
                    AnimCube.vRotY(this.eye, d2);
                    AnimCube.vRotY(this.eyeX, d2);
                    break;
                }
                case 'f': {
                    d2 = -d2;
                }
                case 'b': {
                    AnimCube.vRotZ(this.eye, d2);
                    AnimCube.vRotZ(this.eyeX, d2);
                    break;
                }
                case 'l': {
                    d2 = -d2;
                }
                case 'r': {
                    AnimCube.vRotX(this.eye, d2);
                    AnimCube.vRotX(this.eyeX, d2);
                }
            }
            ++n23;
        }
        AnimCube.vNorm(AnimCube.vMul(this.eyeY, this.eye, this.eyeX));
        this.speed = 0;
        this.doubleSpeed = 0;
        object2 = this.getParameter("speed");
        if (object2 != null) {
            int n24 = 0;
            while (n24 < ((String)object2).length()) {
                if (((String)object2).charAt(n24) >= '0' && ((String)object2).charAt(n24) <= '9') {
                    this.speed = this.speed * 10 + ((String)object2).charAt(n24) - 48;
                }
                ++n24;
            }
        }
        if ((object2 = this.getParameter("doublespeed")) != null) {
            n4 = 0;
            while (n4 < ((String)object2).length()) {
                if (((String)object2).charAt(n4) >= '0' && ((String)object2).charAt(n4) <= '9') {
                    this.doubleSpeed = this.doubleSpeed * 10 + ((String)object2).charAt(n4) - 48;
                }
                ++n4;
            }
        }
        if (this.speed == 0) {
            this.speed = 10;
        }
        if (this.doubleSpeed == 0) {
            this.doubleSpeed = this.speed * 3 / 2;
        }
        this.persp = 0;
        object2 = this.getParameter("perspective");
        if (object2 == null) {
            this.persp = 2;
        } else {
            int n25 = 0;
            while (n25 < ((String)object2).length()) {
                if (((String)object2).charAt(n25) >= '0' && ((String)object2).charAt(n25) <= '9') {
                    this.persp = this.persp * 10 + ((String)object2).charAt(n25) - 48;
                }
                ++n25;
            }
        }
        int n26 = 0;
        object2 = this.getParameter("scale");
        if (object2 != null) {
            int n27 = 0;
            while (n27 < ((String)object2).length()) {
                if (((String)object2).charAt(n27) >= '0' && ((String)object2).charAt(n27) <= '9') {
                    n26 = n26 * 10 + ((String)object2).charAt(n27) - 48;
                }
                ++n27;
            }
        }
        this.scale = 1.0 / (1.0 + (double)n26 / 10.0);
        this.hint = false;
        object2 = this.getParameter("hint");
        if (object2 != null) {
            this.hint = true;
            this.faceShift = 0.0;
            n3 = 0;
            while (n3 < ((String)object2).length()) {
                if (((String)object2).charAt(n3) >= '0' && ((String)object2).charAt(n3) <= '9') {
                    this.faceShift = this.faceShift * 10.0 + (double)((String)object2).charAt(n3) - 48.0;
                }
                ++n3;
            }
            if (this.faceShift < 1.0) {
                this.hint = false;
            } else {
                this.faceShift /= 10.0;
            }
        }
        this.buttonBar = 1;
        this.buttonHeight = 13;
        this.progressHeight = this.move.length == 0 ? 0 : 6;
        object2 = this.getParameter("buttonbar");
        if ("0".equals(object2)) {
            this.buttonBar = 0;
            this.buttonHeight = 0;
            this.progressHeight = 0;
        } else if ("1".equals(object2)) {
            this.buttonBar = 1;
        } else if ("2".equals(object2) || this.move.length == 0) {
            this.buttonBar = 2;
            this.progressHeight = 0;
        }
        object2 = this.getParameter("edit");
        this.editable = !"0".equals(object2);
        object2 = this.getParameter("movetext");
        this.moveText = "1".equals(object2) ? 1 : ("2".equals(object2) ? 2 : ("3".equals(object2) ? 3 : ("4".equals(object2) ? 4 : 0)));
        object2 = this.getParameter("fonttype");
        this.outlined = object2 == null || "1".equals(object2);
        this.metric = 0;
        object2 = this.getParameter("metric");
        if (object2 != null) {
            if ("1".equals(object2)) {
                this.metric = 1;
            } else if ("2".equals(object2)) {
                this.metric = 2;
            } else if ("3".equals(object2)) {
                this.metric = 3;
            }
        }
        this.align = 1;
        object2 = this.getParameter("align");
        if (object2 != null) {
            if ("0".equals(object2)) {
                this.align = 0;
            } else if ("1".equals(object2)) {
                this.align = 1;
            } else if ("2".equals(object2)) {
                this.align = 2;
            }
        }
        n3 = 0;
        while (n3 < 6) {
            int n28 = 0;
            while (n28 < 9) {
                this.initialCube[n3][n28] = this.cube[n3][n28];
                ++n28;
            }
            ++n3;
        }
        int n29 = 0;
        while (n29 < 3) {
            this.initialEye[n29] = this.eye[n29];
            this.initialEyeX[n29] = this.eyeX[n29];
            this.initialEyeY[n29] = this.eyeY[n29];
            ++n29;
        }
        int n30 = this.bgColor.getRed();
        int n31 = (n30 * 299 + (n2 = this.bgColor.getGreen()) * 587 + (n = this.bgColor.getBlue()) * 114) / 1000;
        if (n31 < 128) {
            this.textColor = Color.white;
            this.hlColor = this.bgColor.brighter();
            this.hlColor = new Color(this.hlColor.getBlue(), this.hlColor.getRed(), this.hlColor.getGreen());
        } else {
            this.textColor = Color.black;
            this.hlColor = this.bgColor.darker();
            this.hlColor = new Color(this.hlColor.getBlue(), this.hlColor.getRed(), this.hlColor.getGreen());
        }
        this.bgColor2 = new Color(n30 / 2, n2 / 2, n / 2);
        this.curInfoText = -1;
        if (this.demo) {
            this.startAnimation(-1);
        }
    }

    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        if (string2 == null) {
            return (String)this.config.get(string);
        }
        return string2;
    }

    private int[][] getMove(String string, boolean bl) {
        int n;
        Object object;
        int n2;
        int n3;
        if (bl) {
            n3 = 0;
            n2 = string.indexOf(123);
            while (n2 != -1) {
                ++n3;
                n2 = string.indexOf(123, n2 + 1);
            }
            if (this.infoText == null) {
                this.curInfoText = 0;
                this.infoText = new String[n3];
            } else {
                object = new String[this.infoText.length + n3];
                n = 0;
                while (n < this.infoText.length) {
                    object[n] = (int[])this.infoText[n];
                    ++n;
                }
                this.curInfoText = this.infoText.length;
                this.infoText = (String[])object;
            }
        }
        n3 = 1;
        n2 = string.indexOf(59);
        while (n2 != -1) {
            ++n3;
            n2 = string.indexOf(59, n2 + 1);
        }
        object = new int[n3][];
        n = 0;
        n2 = string.indexOf(59);
        n3 = 0;
        while (n2 != -1) {
            object[n3++] = this.getMovePart(string.substring(n, n2), bl);
            n = n2 + 1;
            n2 = string.indexOf(59, n);
        }
        object[n3] = this.getMovePart(string.substring(n), bl);
        return object;
    }

    private int[] getMovePart(String string, boolean bl) {
        int n;
        int n2 = 0;
        int[] nArray = new int[string.length()];
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == '.') {
                nArray[n2] = -1;
                ++n2;
            } else if (string.charAt(n3) == '{') {
                ++n3;
                String string2 = "";
                while (n3 < string.length()) {
                    if (string.charAt(n3) == '}') break;
                    if (bl) {
                        string2 = string2 + string.charAt(n3);
                    }
                    ++n3;
                }
                if (bl) {
                    this.infoText[this.curInfoText] = string2;
                    nArray[n2] = 1000 + this.curInfoText;
                    ++this.curInfoText;
                    ++n2;
                }
            } else {
                int n4 = 0;
                while (n4 < 21) {
                    if (string.charAt(n3) == "UDFBLRESMXYZxyzudfblr".charAt(n4)) {
                        n = moveModes[n4];
                        nArray[n2] = moveCodes[n4] * 24;
                        if (++n3 < string.length() && moveModes[n4] == 0) {
                            int n5 = 0;
                            while (n5 < modeChar.length) {
                                if (string.charAt(n3) == modeChar[n5]) {
                                    n = n5 + 1;
                                    ++n3;
                                    break;
                                }
                                ++n5;
                            }
                        }
                        int n6 = n2;
                        nArray[n6] = nArray[n6] + n * 4;
                        if (n3 < string.length()) {
                            if (string.charAt(n3) == '1') {
                                ++n3;
                            } else if (string.charAt(n3) == '\'' || string.charAt(n3) == '3') {
                                int n7 = n2;
                                nArray[n7] = nArray[n7] + 2;
                                ++n3;
                            } else if (string.charAt(n3) == '2') {
                                if (++n3 < string.length() && string.charAt(n3) == '\'') {
                                    int n8 = n2;
                                    nArray[n8] = nArray[n8] + 3;
                                    ++n3;
                                } else {
                                    int n9 = n2;
                                    nArray[n9] = nArray[n9] + 1;
                                }
                            }
                        }
                        ++n2;
                        --n3;
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        n = 0;
        while (n < n2) {
            nArray2[n] = nArray[n];
            ++n;
        }
        return nArray2;
    }

    private String moveText(int[] nArray, int n, int n2) {
        if (n >= nArray.length) {
            return "";
        }
        String string = "";
        int n3 = n;
        while (n3 < n2) {
            string = string + this.turnText(nArray, n3);
            ++n3;
        }
        return string;
    }

    private String turnText(int[] nArray, int n) {
        if (n >= nArray.length) {
            return "";
        }
        if (nArray[n] >= 1000) {
            return "";
        }
        if (nArray[n] == -1) {
            return ".";
        }
        String string = turnSymbol[this.moveText - 1][nArray[n] / 4 % 6][nArray[n] / 24];
        if (string.charAt(0) == '~') {
            return string.substring(1) + modifierStrings[(nArray[n] + 2) % 4];
        }
        return string + modifierStrings[nArray[n] % 4];
    }

    private static int realMoveLength(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 1000) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private static int realMovePos(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] < 1000) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private static int arrayMovePos(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n2 < nArray.length && nArray[n2] >= 1000) {
                ++n2;
                continue;
            }
            if (n3 == n) break;
            if (n2 >= nArray.length) continue;
            ++n3;
            ++n2;
        }
        return n2;
    }

    private int moveLength(int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length && (n3 < n || n < 0)) {
            n2 += this.turnLength(nArray[n3]);
            ++n3;
        }
        return n2;
    }

    private int turnLength(int n) {
        if (n < 0 || n >= 1000) {
            return 0;
        }
        int n2 = n % 4;
        int n3 = n / 4 % 6;
        int n4 = 1;
        switch (this.metric) {
            case 1: {
                if (n2 == 1 || n2 == 3) {
                    n4 *= 2;
                }
            }
            case 2: {
                if (n3 == 1 || n3 == 4 || n3 == 5) {
                    n4 *= 2;
                }
            }
            case 3: {
                if (n3 != 3) break;
                n4 = 0;
            }
        }
        return n4;
    }

    private void initInfoText(int[] nArray) {
        this.curInfoText = nArray.length > 0 && nArray[0] >= 1000 ? nArray[0] - 1000 : -1;
    }

    private void doMove(int[][] nArray, int[] nArray2, int n, int n2, boolean bl) {
        int n3;
        int n4 = n3 = bl ? n + n2 : n;
        do {
            if (bl) {
                if (n3 <= n) break;
                --n3;
            }
            if (nArray2[n3] >= 1000) {
                this.curInfoText = bl ? -1 : nArray2[n3] - 1000;
                continue;
            }
            if (nArray2[n3] < 0) continue;
            int n5 = nArray2[n3] % 4 + 1;
            int n6 = nArray2[n3] / 4 % 6;
            if (n5 == 4) {
                n5 = 2;
            }
            if (bl) {
                n5 = 4 - n5;
            }
            this.twistLayers(nArray, nArray2[n3] / 24, n5, n6);
        } while (bl || ++n3 < n + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAnimation(int n) {
        Thread thread = this.animThread;
        synchronized (thread) {
            this.stopAnimation();
            if (!(this.demo || this.move.length != 0 && this.move[this.curMove].length != 0)) {
                return;
            }
            if (this.demo && (this.demoMove.length == 0 || this.demoMove[0].length == 0)) {
                return;
            }
            this.moveDir = 1;
            this.moveOne = false;
            this.moveAnimated = true;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    this.moveDir = -1;
                    break;
                }
                case 2: {
                    this.moveOne = true;
                    break;
                }
                case 3: {
                    this.moveDir = -1;
                    this.moveOne = true;
                    break;
                }
                case 4: {
                    this.moveAnimated = false;
                }
            }
            this.animThread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation() {
        Thread thread = this.animThread;
        synchronized (thread) {
            this.restarted = true;
            this.animThread.notify();
            try {
                this.animThread.wait();
            }
            catch (InterruptedException interruptedException) {
                this.interrupted = true;
            }
            this.restarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = this.animThread;
        synchronized (thread) {
            this.interrupted = false;
            do {
                int[] nArray;
                if (this.restarted) {
                    this.animThread.notify();
                }
                try {
                    this.animThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (this.restarted) continue;
                boolean bl = false;
                this.animating = true;
                this.drawButtons = true;
                int[] nArray2 = nArray = this.demo ? this.demoMove[0] : this.move[this.curMove];
                if (this.moveDir > 0) {
                    if (this.movePos >= nArray.length) {
                        this.movePos = 0;
                        this.initInfoText(nArray);
                    }
                } else {
                    this.curInfoText = -1;
                    if (this.movePos == 0) {
                        this.movePos = nArray.length;
                    }
                }
                do {
                    int n;
                    int n2;
                    if (this.moveDir < 0) {
                        if (this.movePos == 0) break;
                        --this.movePos;
                    }
                    if (nArray[this.movePos] == -1) {
                        this.repaint();
                        if (!this.moveOne) {
                            this.sleep(33 * this.speed);
                        }
                    } else if (nArray[this.movePos] >= 1000) {
                        this.curInfoText = this.moveDir > 0 ? nArray[this.movePos] - 1000 : -1;
                    } else {
                        boolean bl2;
                        n2 = nArray[this.movePos] % 4 + 1;
                        n = nArray[this.movePos] / 4 % 6;
                        boolean bl3 = bl2 = n2 < 3;
                        if (n2 == 4) {
                            n2 = 2;
                        }
                        if (this.moveDir < 0) {
                            bl2 = !bl2;
                            n2 = 4 - n2;
                        }
                        this.spin(nArray[this.movePos] / 24, n2, n, bl2, this.moveAnimated);
                        if (this.moveOne) {
                            bl = true;
                        }
                    }
                    if (this.moveDir > 0) {
                        ++this.movePos;
                        if (this.movePos < nArray.length && nArray[this.movePos] >= 1000) {
                            this.curInfoText = nArray[this.movePos] - 1000;
                            ++this.movePos;
                        }
                        if (this.movePos != nArray.length) continue;
                        if (!this.demo) break;
                        this.movePos = 0;
                        this.initInfoText(nArray);
                        n2 = 0;
                        while (n2 < 6) {
                            n = 0;
                            while (n < 9) {
                                this.cube[n2][n] = this.initialCube[n2][n];
                                ++n;
                            }
                            ++n2;
                        }
                    } else {
                        this.curInfoText = -1;
                    }
                } while (!this.interrupted && !this.restarted && !bl);
                this.animating = false;
                this.drawButtons = true;
                this.repaint();
                if (!this.demo) continue;
                this.clear();
                this.demo = false;
            } while (!this.interrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(int n) {
        Thread thread = this.animThread;
        synchronized (thread) {
            try {
                this.animThread.wait(n);
            }
            catch (InterruptedException interruptedException) {
                this.interrupted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Thread thread = this.animThread;
        synchronized (thread) {
            this.movePos = 0;
            if (this.move.length > 0) {
                this.initInfoText(this.move[this.curMove]);
            }
            this.natural = true;
            this.mirrored = false;
            int n = 0;
            while (n < 6) {
                int n2 = 0;
                while (n2 < 9) {
                    this.cube[n][n2] = this.initialCube[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < 3) {
                this.eye[n3] = this.initialEye[n3];
                this.eyeX[n3] = this.initialEyeX[n3];
                this.eyeY[n3] = this.initialEyeY[n3];
                ++n3;
            }
        }
    }

    private void spin(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.twisting = false;
        this.natural = true;
        this.spinning = true;
        this.originalAngle = 0.0;
        if (faceTwistDirs[n] > 0) {
            boolean bl3 = bl = !bl;
        }
        if (bl2) {
            long l;
            double d = 1.5707963267948966;
            double d2 = bl ? 1.0 : -1.0;
            int n4 = 67 * this.speed;
            if (n2 == 2) {
                d = Math.PI;
                n4 = 67 * this.doubleSpeed;
            }
            this.twisting = true;
            this.twistedLayer = n;
            this.twistedMode = n3;
            this.splitCube(n);
            long l2 = l = System.currentTimeMillis();
            double d3 = d2 * d / (double)n4;
            this.currentAngle = 0.0;
            while (this.currentAngle * d2 < d) {
                this.repaint();
                this.sleep(25);
                if (this.interrupted || this.restarted) break;
                l2 = System.currentTimeMillis();
                this.currentAngle = d3 * (double)(l2 - l);
            }
        }
        this.currentAngle = 0.0;
        this.twisting = false;
        this.natural = true;
        this.twistLayers(this.cube, n, n2, n3);
        this.spinning = false;
        if (bl2) {
            this.repaint();
        }
    }

    private void splitCube(int n) {
        int n2 = 0;
        while (n2 < 6) {
            this.topBlocks[n2] = topBlockTable[topBlockFaceDim[n][n2]];
            this.botBlocks[n2] = topBlockTable[botBlockFaceDim[n][n2]];
            this.midBlocks[n2] = midBlockTable[midBlockFaceDim[n][n2]];
            ++n2;
        }
        this.natural = false;
    }

    private void twistLayers(int[][] nArray, int n, int n2, int n3) {
        switch (n3) {
            case 3: {
                this.twistLayer(nArray, n ^ 1, n2, false);
            }
            case 2: {
                this.twistLayer(nArray, n, 4 - n2, false);
            }
            case 1: {
                this.twistLayer(nArray, n, 4 - n2, true);
                break;
            }
            case 5: {
                this.twistLayer(nArray, n ^ 1, 4 - n2, false);
                this.twistLayer(nArray, n, 4 - n2, false);
                break;
            }
            case 4: {
                this.twistLayer(nArray, n ^ 1, n2, false);
            }
            default: {
                this.twistLayer(nArray, n, 4 - n2, false);
            }
        }
    }

    private void twistLayer(int[][] nArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (!bl) {
            n9 = 0;
            while (n9 < 8) {
                this.twistBuffer[(n9 + n2 * 2) % 8] = nArray[n][cycleOrder[n9]];
                ++n9;
            }
            n8 = 0;
            while (n8 < 8) {
                nArray[n][AnimCube.cycleOrder[n8]] = this.twistBuffer[n8];
                ++n8;
            }
        }
        n9 = n2 * 3;
        n8 = 0;
        while (n8 < 4) {
            n7 = adjacentFaces[n][n8];
            n6 = bl ? cycleCenters[n][n8] : cycleLayerSides[n][n8];
            n5 = cycleFactors[n6];
            n4 = cycleOffsets[n6];
            n3 = 0;
            while (n3 < 3) {
                this.twistBuffer[n9 % 12] = nArray[n7][n3 * n5 + n4];
                ++n9;
                ++n3;
            }
            ++n8;
        }
        n9 = 0;
        n7 = 0;
        while (n7 < 4) {
            n6 = adjacentFaces[n][n7];
            n5 = bl ? cycleCenters[n][n7] : cycleLayerSides[n][n7];
            n4 = cycleFactors[n5];
            n3 = cycleOffsets[n5];
            int n10 = 0;
            while (n10 < 3) {
                nArray[n6][n10 * n4 + n3] = this.twistBuffer[n9];
                ++n10;
                ++n9;
            }
            ++n7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.image == null || dimension.width != this.width || dimension.height - this.buttonHeight != this.height) {
            this.width = dimension.width;
            this.height = dimension.height;
            this.image = this.createImage(this.width, this.height);
            this.graphics = this.image.getGraphics();
            this.textHeight = this.graphics.getFontMetrics().getHeight() - this.graphics.getFontMetrics().getLeading();
            if (this.buttonBar == 1) {
                this.height -= this.buttonHeight;
            }
            this.drawButtons = true;
        }
        this.graphics.setColor(this.bgColor);
        this.graphics.setClip(0, 0, this.width, this.height);
        this.graphics.fillRect(0, 0, this.width, this.height);
        Thread thread = this.animThread;
        synchronized (thread) {
            int n;
            this.dragAreas = 0;
            if (this.natural) {
                this.fixBlock(this.eye, this.eyeX, this.eyeY, cubeBlocks, 3);
            } else {
                double d = Math.cos(this.originalAngle + this.currentAngle);
                double d2 = Math.sin(this.originalAngle + this.currentAngle) * (double)rotSign[this.twistedLayer];
                n = 0;
                while (n < 3) {
                    this.tempEye[n] = 0.0;
                    this.tempEyeX[n] = 0.0;
                    int n2 = 0;
                    while (n2 < 3) {
                        int n3 = this.twistedLayer / 2;
                        int n4 = n;
                        this.tempEye[n4] = this.tempEye[n4] + this.eye[n2] * ((double)rotVec[n3][n][n2] + (double)rotCos[n3][n][n2] * d + (double)rotSin[n3][n][n2] * d2);
                        int n5 = n;
                        this.tempEyeX[n5] = this.tempEyeX[n5] + this.eyeX[n2] * ((double)rotVec[n3][n][n2] + (double)rotCos[n3][n][n2] * d + (double)rotSin[n3][n][n2] * d2);
                        ++n2;
                    }
                    ++n;
                }
                AnimCube.vMul(this.tempEyeY, this.tempEye, this.tempEyeX);
                double d3 = Math.cos(this.originalAngle - this.currentAngle);
                double d4 = Math.sin(this.originalAngle - this.currentAngle) * (double)rotSign[this.twistedLayer];
                int n6 = 0;
                while (n6 < 3) {
                    this.tempEye2[n6] = 0.0;
                    this.tempEyeX2[n6] = 0.0;
                    int n7 = 0;
                    while (n7 < 3) {
                        int n8 = this.twistedLayer / 2;
                        int n9 = n6;
                        this.tempEye2[n9] = this.tempEye2[n9] + this.eye[n7] * ((double)rotVec[n8][n6][n7] + (double)rotCos[n8][n6][n7] * d3 + (double)rotSin[n8][n6][n7] * d4);
                        int n10 = n6;
                        this.tempEyeX2[n10] = this.tempEyeX2[n10] + this.eyeX[n7] * ((double)rotVec[n8][n6][n7] + (double)rotCos[n8][n6][n7] * d3 + (double)rotSin[n8][n6][n7] * d4);
                        ++n7;
                    }
                    ++n6;
                }
                AnimCube.vMul(this.tempEyeY2, this.tempEye2, this.tempEyeX2);
                this.eyeArray[0] = this.eye;
                this.eyeArrayX[0] = this.eyeX;
                this.eyeArrayY[0] = this.eyeY;
                this.eyeArray[1] = this.tempEye;
                this.eyeArrayX[1] = this.tempEyeX;
                this.eyeArrayY[1] = this.tempEyeY;
                this.eyeArray[2] = this.tempEye2;
                this.eyeArrayX[2] = this.tempEyeX2;
                this.eyeArrayY[2] = this.tempEyeY2;
                this.blockArray[0] = this.topBlocks;
                this.blockArray[1] = this.midBlocks;
                this.blockArray[2] = this.botBlocks;
                AnimCube.vSub(AnimCube.vScale(AnimCube.vCopy(this.perspEye, this.eye), 5.0 + (double)this.persp), AnimCube.vScale(AnimCube.vCopy(this.perspNormal, faceNormals[this.twistedLayer]), 0.3333333333333333));
                AnimCube.vSub(AnimCube.vScale(AnimCube.vCopy(this.perspEyeI, this.eye), 5.0 + (double)this.persp), AnimCube.vScale(AnimCube.vCopy(this.perspNormal, faceNormals[this.twistedLayer ^ 1]), 0.3333333333333333));
                double d5 = AnimCube.vProd(this.perspEye, faceNormals[this.twistedLayer]);
                double d6 = AnimCube.vProd(this.perspEyeI, faceNormals[this.twistedLayer ^ 1]);
                int n11 = d5 < 0.0 && d6 > 0.0 ? 0 : (d5 > 0.0 && d6 < 0.0 ? 1 : 2);
                this.fixBlock(this.eyeArray[this.eyeOrder[this.twistedMode][this.drawOrder[n11][0]]], this.eyeArrayX[this.eyeOrder[this.twistedMode][this.drawOrder[n11][0]]], this.eyeArrayY[this.eyeOrder[this.twistedMode][this.drawOrder[n11][0]]], this.blockArray[this.drawOrder[n11][0]], this.blockMode[this.twistedMode][this.drawOrder[n11][0]]);
                this.fixBlock(this.eyeArray[this.eyeOrder[this.twistedMode][this.drawOrder[n11][1]]], this.eyeArrayX[this.eyeOrder[this.twistedMode][this.drawOrder[n11][1]]], this.eyeArrayY[this.eyeOrder[this.twistedMode][this.drawOrder[n11][1]]], this.blockArray[this.drawOrder[n11][1]], this.blockMode[this.twistedMode][this.drawOrder[n11][1]]);
                this.fixBlock(this.eyeArray[this.eyeOrder[this.twistedMode][this.drawOrder[n11][2]]], this.eyeArrayX[this.eyeOrder[this.twistedMode][this.drawOrder[n11][2]]], this.eyeArrayY[this.eyeOrder[this.twistedMode][this.drawOrder[n11][2]]], this.blockArray[this.drawOrder[n11][2]], this.blockMode[this.twistedMode][this.drawOrder[n11][2]]);
            }
            if (!this.pushed && !this.animating) {
                this.buttonPressed = -1;
            }
            if (!this.demo && this.move.length > 0) {
                int n12;
                if (this.move[this.curMove].length > 0) {
                    this.graphics.setColor(Color.black);
                    this.graphics.drawRect(0, this.height - this.progressHeight, this.width - 1, this.progressHeight - 1);
                    this.graphics.setColor(this.textColor);
                    int n13 = (this.width - 2) * AnimCube.realMovePos(this.move[this.curMove], this.movePos) / AnimCube.realMoveLength(this.move[this.curMove]);
                    this.graphics.fillRect(1, this.height - this.progressHeight + 1, n13, this.progressHeight - 2);
                    this.graphics.setColor(this.bgColor.darker());
                    this.graphics.fillRect(1 + n13, this.height - this.progressHeight + 1, this.width - 2 - n13, this.progressHeight - 2);
                    String string = "" + this.moveLength(this.move[this.curMove], this.movePos) + "/" + this.moveLength(this.move[this.curMove], -1) + metricChar[this.metric];
                    int n14 = this.graphics.getFontMetrics().stringWidth(string);
                    n12 = this.width - n14 - 2;
                    n = this.height - this.progressHeight - 2;
                    if (this.moveText > 0 && this.textHeight > 0) {
                        this.drawString(this.graphics, string, n12, n - this.textHeight);
                        this.drawMoveText(this.graphics, n);
                    } else {
                        this.drawString(this.graphics, string, n12, n);
                    }
                }
                if (this.move.length > 1) {
                    this.graphics.setClip(0, 0, this.width, this.height);
                    int n15 = this.graphics.getFontMetrics().getDescent();
                    int n16 = this.textHeight - n15;
                    String string = "" + (this.curMove + 1) + "/" + this.move.length;
                    n12 = this.graphics.getFontMetrics().stringWidth(string);
                    n = this.width - n12 - this.buttonHeight - 2;
                    this.drawString(this.graphics, string, n, n16);
                    this.graphics.setColor(this.buttonBgColor);
                    this.graphics.fill3DRect(this.width - this.buttonHeight, 0, this.buttonHeight, this.buttonHeight, this.buttonPressed != 7);
                    this.drawButton(this.graphics, 7, this.width - this.buttonHeight / 2, this.buttonHeight / 2);
                }
            }
            if (this.curInfoText >= 0) {
                this.graphics.setClip(0, 0, this.width, this.height);
                int n17 = this.graphics.getFontMetrics().getDescent();
                int n18 = this.textHeight - n17;
                this.drawString(this.graphics, this.infoText[this.curInfoText], 0, n18);
            }
            if (this.drawButtons && this.buttonBar != 0) {
                this.drawButtons(this.graphics);
            }
        }
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void fixBlock(double[] dArray, double[] dArray2, double[] dArray3, int[][][] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        double d;
        double d2;
        double d3;
        int n8 = 0;
        while (n8 < 8) {
            double d4 = this.width < this.height ? (double)this.width : (double)(this.height - this.progressHeight);
            d3 = d4 / 3.7 * AnimCube.vProd(cornerCoords[n8], dArray2) * this.scale;
            d2 = d4 / 3.7 * AnimCube.vProd(cornerCoords[n8], dArray3) * this.scale;
            d = d4 / (5.0 + (double)this.persp) * AnimCube.vProd(cornerCoords[n8], dArray) * this.scale;
            this.coordsX[n8] = (double)this.width / 2.0 + (d3 /= 1.0 - d / d4);
            this.coordsY[n8] = this.align == 0 ? (double)(this.height - this.progressHeight) / 2.0 * this.scale - d2 : (this.align == 2 ? (double)(this.height - this.progressHeight) - (double)(this.height - this.progressHeight) / 2.0 * this.scale - d2 : (double)(this.height - this.progressHeight) / 2.0 - (d2 /= 1.0 - d / d4));
            ++n8;
        }
        int n9 = 0;
        while (n9 < 6) {
            n7 = 0;
            while (n7 < 4) {
                this.cooX[n9][n7] = this.coordsX[faceCorners[n9][n7]];
                this.cooY[n9][n7] = this.coordsY[faceCorners[n9][n7]];
                ++n7;
            }
            ++n9;
        }
        if (this.hint) {
            n7 = 0;
            while (n7 < 6) {
                AnimCube.vSub(AnimCube.vScale(AnimCube.vCopy(this.perspEye, dArray), 5.0 + (double)this.persp), faceNormals[n7]);
                if (AnimCube.vProd(this.perspEye, faceNormals[n7]) < 0.0) {
                    AnimCube.vScale(AnimCube.vCopy(this.tempNormal, faceNormals[n7]), this.faceShift);
                    d3 = this.width < this.height ? (double)this.width : (double)(this.height - this.progressHeight);
                    d2 = d3 / 3.7 * AnimCube.vProd(this.tempNormal, dArray2);
                    d = d3 / 3.7 * AnimCube.vProd(this.tempNormal, dArray3);
                    double d5 = d3 / (5.0 + (double)this.persp) * AnimCube.vProd(this.tempNormal, dArray);
                    d2 /= 1.0 - d5 / d3;
                    d /= 1.0 - d5 / d3;
                    n6 = nArray[n7][0][1] - nArray[n7][0][0];
                    int n10 = nArray[n7][1][1] - nArray[n7][1][0];
                    if (n6 > 0 && n10 > 0) {
                        int n11 = 0;
                        int n12 = nArray[n7][1][0];
                        while (n11 < n10) {
                            n5 = 0;
                            n4 = nArray[n7][0][0];
                            while (n5 < n6) {
                                int n13 = 0;
                                while (n13 < 4) {
                                    this.getCorners(n7, n13, this.fillX, this.fillY, (double)n4 + border[n13][0], (double)n12 + border[n13][1], this.mirrored);
                                    int n14 = n13;
                                    this.fillX[n14] = (int)((double)this.fillX[n14] + (this.mirrored ? -d2 : d2));
                                    int n15 = n13++;
                                    this.fillY[n15] = (int)((double)this.fillY[n15] - d);
                                }
                                this.graphics.setColor(this.colors[this.cube[n7][n12 * 3 + n4]]);
                                this.graphics.fillPolygon(this.fillX, this.fillY, 4);
                                this.graphics.setColor(this.colors[this.cube[n7][n12 * 3 + n4]].darker());
                                this.graphics.drawPolygon(this.fillX, this.fillY, 4);
                                ++n5;
                                ++n4;
                            }
                            ++n11;
                            ++n12;
                        }
                    }
                }
                ++n7;
            }
        }
        n7 = 0;
        while (n7 < 6) {
            int n16 = nArray[n7][0][1] - nArray[n7][0][0];
            n3 = nArray[n7][1][1] - nArray[n7][1][0];
            if (n16 > 0 && n3 > 0) {
                int n17 = 0;
                while (n17 < 4) {
                    this.getCorners(n7, n17, this.fillX, this.fillY, nArray[n7][0][factors[n17][0]], nArray[n7][1][factors[n17][1]], this.mirrored);
                    ++n17;
                }
                if (n16 == 3 && n3 == 3) {
                    this.graphics.setColor(this.bgColor2);
                } else {
                    this.graphics.setColor(Color.black);
                }
                this.graphics.drawPolygon(this.fillX, this.fillY, 4);
            }
            ++n7;
        }
        int n18 = 0;
        while (n18 < 6) {
            n3 = nArray[n18][0][1] - nArray[n18][0][0];
            int n19 = nArray[n18][1][1] - nArray[n18][1][0];
            if (n3 <= 0 || n19 <= 0) {
                n2 = 0;
                while (n2 < 4) {
                    int n20 = oppositeCorners[n18][n2];
                    this.fillX[n2] = (int)(this.cooX[n18][n2] + (this.cooX[n18 ^ 1][n20] - this.cooX[n18][n2]) * 2.0 / 3.0);
                    this.fillY[n2] = (int)(this.cooY[n18][n2] + (this.cooY[n18 ^ 1][n20] - this.cooY[n18][n2]) * 2.0 / 3.0);
                    if (this.mirrored) {
                        this.fillX[n2] = this.width - this.fillX[n2];
                    }
                    ++n2;
                }
                this.graphics.setColor(Color.black);
                this.graphics.fillPolygon(this.fillX, this.fillY, 4);
            } else {
                n2 = 0;
                while (n2 < 4) {
                    this.getCorners(n18, n2, this.fillX, this.fillY, nArray[n18][0][factors[n2][0]], nArray[n18][1][factors[n2][1]], this.mirrored);
                    ++n2;
                }
                this.graphics.setColor(Color.black);
                this.graphics.fillPolygon(this.fillX, this.fillY, 4);
            }
            ++n18;
        }
        n3 = 0;
        while (n3 < 6) {
            AnimCube.vSub(AnimCube.vScale(AnimCube.vCopy(this.perspEye, dArray), 5.0 + (double)this.persp), faceNormals[n3]);
            if (AnimCube.vProd(this.perspEye, faceNormals[n3]) > 0.0) {
                int n21 = nArray[n3][0][1] - nArray[n3][0][0];
                n2 = nArray[n3][1][1] - nArray[n3][1][0];
                if (n21 > 0 && n2 > 0) {
                    int n22 = 0;
                    int n23 = nArray[n3][1][0];
                    while (n22 < n2) {
                        int n24 = 0;
                        int n25 = nArray[n3][0][0];
                        while (n24 < n21) {
                            n6 = 0;
                            while (n6 < 4) {
                                this.getCorners(n3, n6, this.fillX, this.fillY, (double)n25 + border[n6][0], (double)n23 + border[n6][1], this.mirrored);
                                ++n6;
                            }
                            this.graphics.setColor(this.colors[this.cube[n3][n23 * 3 + n25]].darker());
                            this.graphics.drawPolygon(this.fillX, this.fillY, 4);
                            this.graphics.setColor(this.colors[this.cube[n3][n23 * 3 + n25]]);
                            this.graphics.fillPolygon(this.fillX, this.fillY, 4);
                            ++n24;
                            ++n25;
                        }
                        ++n22;
                        ++n23;
                    }
                }
                if (this.editable && !this.animating) {
                    double d6 = (this.cooX[n3][1] - this.cooX[n3][0] + this.cooX[n3][2] - this.cooX[n3][3]) / 6.0;
                    double d7 = (this.cooX[n3][3] - this.cooX[n3][0] + this.cooX[n3][2] - this.cooX[n3][1]) / 6.0;
                    double d8 = (this.cooY[n3][1] - this.cooY[n3][0] + this.cooY[n3][2] - this.cooY[n3][3]) / 6.0;
                    double d9 = (this.cooY[n3][3] - this.cooY[n3][0] + this.cooY[n3][2] - this.cooY[n3][1]) / 6.0;
                    if (n == 3) {
                        n5 = 0;
                        while (n5 < 6) {
                            n4 = 0;
                            while (n4 < 4) {
                                this.getCorners(n3, n4, this.dragCornersX[this.dragAreas], this.dragCornersY[this.dragAreas], dragBlocks[n5][n4][0], dragBlocks[n5][n4][1], false);
                                ++n4;
                            }
                            this.dragDirsX[this.dragAreas] = (d6 * (double)areaDirs[n5][0] + d8 * (double)areaDirs[n5][1]) * (double)twistDirs[n3][n5];
                            this.dragDirsY[this.dragAreas] = (d7 * (double)areaDirs[n5][0] + d9 * (double)areaDirs[n5][1]) * (double)twistDirs[n3][n5];
                            this.dragLayers[this.dragAreas] = adjacentFaces[n3][n5 % 4];
                            if (n5 >= 4) {
                                int n26 = this.dragAreas;
                                this.dragLayers[n26] = this.dragLayers[n26] & 0xFFFFFFFE;
                            }
                            this.dragModes[this.dragAreas] = n5 / 4;
                            ++this.dragAreas;
                            if (this.dragAreas != 18) {
                                ++n5;
                                continue;
                            }
                            break;
                        }
                    } else if (n == 0) {
                        if (n3 != this.twistedLayer && n21 > 0 && n2 > 0) {
                            n5 = n21 == 3 ? (nArray[n3][1][0] == 0 ? 0 : 2) : (nArray[n3][0][0] == 0 ? 3 : 1);
                            n4 = 0;
                            while (n4 < 4) {
                                this.getCorners(n3, n4, this.dragCornersX[this.dragAreas], this.dragCornersY[this.dragAreas], dragBlocks[n5][n4][0], dragBlocks[n5][n4][1], false);
                                ++n4;
                            }
                            this.dragDirsX[this.dragAreas] = (d6 * (double)areaDirs[n5][0] + d8 * (double)areaDirs[n5][1]) * (double)twistDirs[n3][n5];
                            this.dragDirsY[this.dragAreas] = (d7 * (double)areaDirs[n5][0] + d9 * (double)areaDirs[n5][1]) * (double)twistDirs[n3][n5];
                            this.dragLayers[this.dragAreas] = this.twistedLayer;
                            this.dragModes[this.dragAreas] = 0;
                            ++this.dragAreas;
                        }
                    } else if (n == 1 && n3 != this.twistedLayer && n21 > 0 && n2 > 0) {
                        n5 = n21 == 3 ? 4 : 5;
                        n4 = 0;
                        while (n4 < 4) {
                            this.getCorners(n3, n4, this.dragCornersX[this.dragAreas], this.dragCornersY[this.dragAreas], dragBlocks[n5][n4][0], dragBlocks[n5][n4][1], false);
                            ++n4;
                        }
                        this.dragDirsX[this.dragAreas] = (d6 * (double)areaDirs[n5][0] + d8 * (double)areaDirs[n5][1]) * (double)twistDirs[n3][n5];
                        this.dragDirsY[this.dragAreas] = (d7 * (double)areaDirs[n5][0] + d9 * (double)areaDirs[n5][1]) * (double)twistDirs[n3][n5];
                        this.dragLayers[this.dragAreas] = this.twistedLayer;
                        this.dragModes[this.dragAreas] = 1;
                        ++this.dragAreas;
                    }
                }
            }
            ++n3;
        }
    }

    private void getCorners(int n, int n2, int[] nArray, int[] nArray2, double d, double d2, boolean bl) {
        double d3 = this.cooX[n][0] + (this.cooX[n][1] - this.cooX[n][0]) * (d /= 3.0);
        double d4 = this.cooY[n][0] + (this.cooY[n][1] - this.cooY[n][0]) * d;
        double d5 = this.cooX[n][3] + (this.cooX[n][2] - this.cooX[n][3]) * d;
        double d6 = this.cooY[n][3] + (this.cooY[n][2] - this.cooY[n][3]) * d;
        nArray[n2] = (int)(0.5 + d3 + (d5 - d3) * (d2 /= 3.0));
        nArray2[n2] = (int)(0.5 + d4 + (d6 - d4) * d2);
        if (bl) {
            nArray[n2] = this.width - nArray[n2];
        }
    }

    private void drawButtons(Graphics graphics) {
        if (this.buttonBar == 2) {
            graphics.setColor(this.buttonBgColor);
            graphics.fill3DRect(0, this.height - this.buttonHeight, this.buttonHeight, this.buttonHeight, this.buttonPressed != 0);
            this.drawButton(graphics, 0, this.buttonHeight / 2, this.height - (this.buttonHeight + 1) / 2);
            return;
        }
        if (this.buttonBar == 1) {
            graphics.setClip(0, this.height, this.width, this.buttonHeight);
            int n = 0;
            int n2 = 0;
            while (n2 < 7) {
                int n3 = (this.width - n) / (7 - n2);
                graphics.setColor(this.buttonBgColor);
                graphics.fill3DRect(n, this.height, n3, this.buttonHeight, this.buttonPressed != n2);
                this.drawButton(graphics, n2, n + n3 / 2, this.height + this.buttonHeight / 2);
                n += n3;
                ++n2;
            }
            this.drawButtons = false;
            return;
        }
    }

    private void drawButton(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.white);
        switch (n) {
            case 0: {
                AnimCube.drawRect(graphics, n2 - 4, n3 - 3, 3, 7);
                AnimCube.drawArrow(graphics, n2 + 3, n3, -1);
                break;
            }
            case 1: {
                AnimCube.drawRect(graphics, n2 + 2, n3 - 3, 3, 7);
                AnimCube.drawArrow(graphics, n2, n3, -1);
                break;
            }
            case 2: {
                AnimCube.drawArrow(graphics, n2 + 2, n3, -1);
                break;
            }
            case 3: {
                if (this.animating) {
                    AnimCube.drawRect(graphics, n2 - 3, n3 - 3, 7, 7);
                    break;
                }
                AnimCube.drawRect(graphics, n2 - 3, n3 - 2, 7, 5);
                AnimCube.drawRect(graphics, n2 - 1, n3 - 4, 3, 9);
                break;
            }
            case 4: {
                AnimCube.drawArrow(graphics, n2 - 2, n3, 1);
                break;
            }
            case 5: {
                AnimCube.drawRect(graphics, n2 - 4, n3 - 3, 3, 7);
                AnimCube.drawArrow(graphics, n2, n3, 1);
                break;
            }
            case 6: {
                AnimCube.drawRect(graphics, n2 + 1, n3 - 3, 3, 7);
                AnimCube.drawArrow(graphics, n2 - 4, n3, 1);
                break;
            }
            case 7: {
                AnimCube.drawArrow(graphics, n2 - 2, n3, 1);
            }
        }
    }

    private static void drawArrow(Graphics graphics, int n, int n2, int n3) {
        int n4;
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2 - 3, n, n2 + 3);
        n += n3;
        int n5 = 0;
        while (n5 >= -3 && n5 <= 3) {
            n4 = 3 - n5 * n3;
            graphics.drawLine(n + n5, n2 + n4, n + n5, n2 - n4);
            n5 += n3;
        }
        graphics.setColor(Color.white);
        n4 = 0;
        while (n4 >= -1 && n4 <= 1) {
            int n6 = 1 - n4 * n3;
            graphics.drawLine(n + n4, n2 + n6, n + n4, n2 - n6);
            n4 += n3;
        }
    }

    private static void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(Color.white);
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }

    private void drawString(Graphics graphics, String string, int n, int n2) {
        if (this.outlined) {
            graphics.setColor(Color.black);
            int n3 = 0;
            while (n3 < textOffset.length) {
                graphics.drawString(string, n + textOffset[n3], n2 + textOffset[n3 + 1]);
                n3 += 2;
            }
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(this.textColor);
        }
        graphics.drawString(string, n, n2);
    }

    private void drawMoveText(Graphics graphics, int n) {
        graphics.setClip(0, this.height - this.progressHeight - this.textHeight, this.width, this.textHeight);
        graphics.setColor(Color.black);
        int n2 = this.movePos == 0 ? AnimCube.arrayMovePos(this.move[this.curMove], this.movePos) : this.movePos;
        String string = this.moveText(this.move[this.curMove], 0, n2);
        String string2 = this.turnText(this.move[this.curMove], n2);
        String string3 = this.moveText(this.move[this.curMove], n2 + 1, this.move[this.curMove].length);
        int n3 = graphics.getFontMetrics().stringWidth(string);
        int n4 = graphics.getFontMetrics().stringWidth(string2);
        int n5 = graphics.getFontMetrics().stringWidth(string3);
        int n6 = 1;
        if (n6 + n3 + n4 + n5 > this.width) {
            n6 = Math.min(1, this.width / 2 - n3 - n4 / 2);
            n6 = Math.max(n6, this.width - n3 - n4 - n5 - 2);
        }
        if (n4 > 0) {
            graphics.setColor(this.hlColor);
            graphics.fillRect(n6 + n3 - 1, this.height - this.progressHeight - this.textHeight, n4 + 2, this.textHeight);
        }
        if (n3 > 0) {
            this.drawString(graphics, string, n6, n);
        }
        if (n4 > 0) {
            this.drawString(graphics, string2, n6 + n3, n);
        }
        if (n5 > 0) {
            this.drawString(graphics, string3, n6 + n3 + n4, n);
        }
    }

    private int selectButton(int n, int n2) {
        if (this.buttonBar == 0) {
            return -1;
        }
        if (this.move.length > 1 && n >= this.width - this.buttonHeight && n < this.width && n2 >= 0 && n2 < this.buttonHeight) {
            return 7;
        }
        if (this.buttonBar == 2) {
            if (n >= 0 && n < this.buttonHeight && n2 >= this.height - this.buttonHeight && n2 < this.height) {
                return 0;
            }
            return -1;
        }
        if (n2 < this.height) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < 7) {
            int n5 = (this.width - n3) / (7 - n4);
            if (n >= n3 && n < n3 + n5 && n2 >= this.height && n2 < this.height + this.buttonHeight) {
                return n4;
            }
            n3 += n5;
            ++n4;
        }
        return -1;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.lastDragX = this.lastX = mouseEvent.getX();
        this.lastDragY = this.lastY = mouseEvent.getY();
        this.toTwist = false;
        this.buttonPressed = this.selectButton(this.lastX, this.lastY);
        if (this.buttonPressed >= 0) {
            this.pushed = true;
            if (this.buttonPressed == 3) {
                if (!this.animating) {
                    this.mirrored = !this.mirrored;
                } else {
                    this.stopAnimation();
                }
            } else if (this.buttonPressed == 0) {
                this.stopAnimation();
                this.clear();
            } else if (this.buttonPressed == 7) {
                this.stopAnimation();
                this.clear();
                this.curMove = this.curMove < this.move.length - 1 ? this.curMove + 1 : 0;
            } else {
                this.startAnimation(buttonAction[this.buttonPressed]);
            }
            this.drawButtons = true;
            this.repaint();
        } else if (this.progressHeight > 0 && this.move.length > 0 && this.move[this.curMove].length > 0 && this.lastY >= this.height - this.progressHeight && this.lastY < this.height) {
            this.stopAnimation();
            int n = AnimCube.realMoveLength(this.move[this.curMove]);
            int n2 = ((this.lastX - 1) * n * 2 / (this.width - 2) + 1) / 2;
            n2 = Math.max(0, Math.min(n, n2));
            if (n2 > 0) {
                n2 = AnimCube.arrayMovePos(this.move[this.curMove], n2);
            }
            if (n2 > this.movePos) {
                this.doMove(this.cube, this.move[this.curMove], this.movePos, n2 - this.movePos, false);
            }
            if (n2 < this.movePos) {
                this.doMove(this.cube, this.move[this.curMove], n2, this.movePos - n2, true);
            }
            this.movePos = n2;
            this.dragging = true;
            this.repaint();
        } else {
            if (this.mirrored) {
                this.lastDragX = this.lastX = this.width - this.lastX;
            }
            if (this.editable && !this.animating && (mouseEvent.getModifiers() & 0x10) != 0 && (mouseEvent.getModifiers() & 1) == 0) {
                this.toTwist = true;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
        if (this.pushed) {
            this.pushed = false;
            this.drawButtons = true;
            this.repaint();
        } else if (this.twisting && !this.spinning) {
            this.twisting = false;
            this.originalAngle += this.currentAngle;
            this.currentAngle = 0.0;
            double d = this.originalAngle;
            while (d < 0.0) {
                d += 100.53096491487338;
            }
            int n = (int)(d * 8.0 / Math.PI) % 16;
            if (n % 4 == 0 || n % 4 == 3) {
                n = (n + 1) / 4;
                if (faceTwistDirs[this.twistedLayer] > 0) {
                    n = (4 - n) % 4;
                }
                this.originalAngle = 0.0;
                this.natural = true;
                this.twistLayers(this.cube, this.twistedLayer, n, this.twistedMode);
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pushed) {
            return;
        }
        if (this.dragging) {
            this.stopAnimation();
            int n = AnimCube.realMoveLength(this.move[this.curMove]);
            int n2 = ((mouseEvent.getX() - 1) * n * 2 / (this.width - 2) + 1) / 2;
            n2 = Math.max(0, Math.min(n, n2));
            if (n2 > 0) {
                n2 = AnimCube.arrayMovePos(this.move[this.curMove], n2);
            }
            if (n2 > this.movePos) {
                this.doMove(this.cube, this.move[this.curMove], this.movePos, n2 - this.movePos, false);
            }
            if (n2 < this.movePos) {
                this.doMove(this.cube, this.move[this.curMove], n2, this.movePos - n2, true);
            }
            this.movePos = n2;
            this.repaint();
            return;
        }
        int n = this.mirrored ? this.width - mouseEvent.getX() : mouseEvent.getX();
        int n3 = mouseEvent.getY();
        int n4 = n - this.lastX;
        int n5 = n3 - this.lastY;
        if (this.editable && this.toTwist && !this.twisting && !this.animating) {
            this.lastDragX = n;
            this.lastDragY = n3;
            int n6 = 0;
            while (n6 < this.dragAreas) {
                double d = this.dragCornersX[n6][0];
                double d2 = (double)this.dragCornersX[n6][1] - d;
                double d3 = (double)this.dragCornersX[n6][3] - d;
                double d4 = this.dragCornersY[n6][0];
                double d5 = (double)this.dragCornersY[n6][1] - d4;
                double d6 = (double)this.dragCornersY[n6][3] - d4;
                double d7 = (d6 * ((double)this.lastX - d) - d3 * ((double)this.lastY - d4)) / (d2 * d6 - d3 * d5);
                double d8 = (-d5 * ((double)this.lastX - d) + d2 * ((double)this.lastY - d4)) / (d2 * d6 - d3 * d5);
                if (d7 > 0.0 && d7 < 1.0 && d8 > 0.0 && d8 < 1.0) {
                    if (n4 * n4 + n5 * n5 < 144) {
                        return;
                    }
                    this.dragX = this.dragDirsX[n6];
                    this.dragY = this.dragDirsY[n6];
                    double d9 = Math.abs(this.dragX * (double)n4 + this.dragY * (double)n5) / Math.sqrt((this.dragX * this.dragX + this.dragY * this.dragY) * (double)(n4 * n4 + n5 * n5));
                    if (d9 > 0.75) {
                        this.twisting = true;
                        this.twistedLayer = this.dragLayers[n6];
                        this.twistedMode = this.dragModes[n6];
                        break;
                    }
                }
                ++n6;
            }
            this.toTwist = false;
            this.lastX = this.lastDragX;
            this.lastY = this.lastDragY;
        }
        n4 = n - this.lastX;
        n5 = n3 - this.lastY;
        if (!this.twisting || this.animating) {
            AnimCube.vNorm(AnimCube.vAdd(this.eye, AnimCube.vScale(AnimCube.vCopy(this.eyeD, this.eyeX), (double)n4 * -0.016)));
            AnimCube.vNorm(AnimCube.vMul(this.eyeX, this.eyeY, this.eye));
            AnimCube.vNorm(AnimCube.vAdd(this.eye, AnimCube.vScale(AnimCube.vCopy(this.eyeD, this.eyeY), (double)n5 * 0.016)));
            AnimCube.vNorm(AnimCube.vMul(this.eyeY, this.eye, this.eyeX));
            this.lastX = n;
            this.lastY = n3;
        } else {
            if (this.natural) {
                this.splitCube(this.twistedLayer);
            }
            this.currentAngle = 0.03 * (this.dragX * (double)n4 + this.dragY * (double)n5) / Math.sqrt(this.dragX * this.dragX + this.dragY * this.dragY);
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        String string = "Drag the cube with a mouse";
        if (n >= 0 && n < this.width) {
            if (n2 >= this.height && n2 < this.height + this.buttonHeight || n2 >= 0 && n2 < this.buttonHeight) {
                this.buttonPressed = this.selectButton(n, n2);
                if (this.buttonPressed >= 0) {
                    string = buttonDescriptions[this.buttonPressed];
                }
                if (this.buttonPressed == 3 && !this.animating) {
                    string = "Mirror the cube view";
                }
            } else if (this.progressHeight > 0 && this.move.length > 0 && this.move[this.curMove].length > 0 && n2 >= this.height - this.progressHeight && n2 < this.height) {
                string = "Current progress";
            }
        }
        if (string != this.buttonDescription) {
            this.buttonDescription = string;
            this.showStatus(string);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private static double[] vCopy(double[] dArray, double[] dArray2) {
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = dArray2[2];
        return dArray;
    }

    private static double[] vNorm(double[] dArray) {
        double d = Math.sqrt(AnimCube.vProd(dArray, dArray));
        dArray[0] = dArray[0] / d;
        dArray[1] = dArray[1] / d;
        dArray[2] = dArray[2] / d;
        return dArray;
    }

    private static double[] vScale(double[] dArray, double d) {
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        dArray[2] = dArray[2] * d;
        return dArray;
    }

    private static double vProd(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    private static double[] vAdd(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] + dArray2[0];
        dArray[1] = dArray[1] + dArray2[1];
        dArray[2] = dArray[2] + dArray2[2];
        return dArray;
    }

    private static double[] vSub(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] - dArray2[0];
        dArray[1] = dArray[1] - dArray2[1];
        dArray[2] = dArray[2] - dArray2[2];
        return dArray;
    }

    private static double[] vMul(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[1] * dArray3[2] - dArray2[2] * dArray3[1];
        dArray[1] = dArray2[2] * dArray3[0] - dArray2[0] * dArray3[2];
        dArray[2] = dArray2[0] * dArray3[1] - dArray2[1] * dArray3[0];
        return dArray;
    }

    private static double[] vRotX(double[] dArray, double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = dArray[1] * d3 - dArray[2] * d2;
        double d5 = dArray[1] * d2 + dArray[2] * d3;
        dArray[1] = d4;
        dArray[2] = d5;
        return dArray;
    }

    private static double[] vRotY(double[] dArray, double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = dArray[0] * d3 - dArray[2] * d2;
        double d5 = dArray[0] * d2 + dArray[2] * d3;
        dArray[0] = d4;
        dArray[2] = d5;
        return dArray;
    }

    private static double[] vRotZ(double[] dArray, double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = dArray[0] * d3 - dArray[1] * d2;
        double d5 = dArray[0] * d2 + dArray[1] * d3;
        dArray[0] = d4;
        dArray[1] = d5;
        return dArray;
    }
}

