
public final class Transform4 {
  public final TransformCornTwist4 cornTwist;
  public final TransformCornPerm4 cornPerm;
  public final TransformMidLoc4[] midLoc;
  public final TransformEdgePos4[] edgePos;
  public final TransformACornPerm4 aCornPerm;
  public final TransformOCornPerm4 oCornPerm;

  public Transform4(CubeState4 state) {
    System.err.println("Transformation tables...");
    cornTwist = new TransformCornTwist4(state.coActive);
    cornPerm = new TransformCornPerm4(state.cActive);
    midLoc = new TransformMidLoc4[6];
    for (int i = 0; i < 6; i++)
      midLoc[i] = new TransformMidLoc4(state.mActive, i * 4);
    edgePos = new TransformEdgePos4[12];
    for (int i = 0; i < 12; i++)
      edgePos[i] = new TransformEdgePos4(state.eActive, i * 2);
    aCornPerm = new TransformACornPerm4(state.cActive);
    oCornPerm = new TransformOCornPerm4(state.cActive);
  }

  public Transform4() {
    System.err.println("Full transformation tables...");
    cornTwist = new TransformCornTwist4(0);
    cornPerm = new TransformCornPerm4(0);
    midLoc = new TransformMidLoc4[6];
    for (int i = 0; i < 6; i++)
      midLoc[i] = new TransformMidLoc4(0, i * 4);
    edgePos = new TransformEdgePos4[12];
    for (int i = 0; i < 12; i++)
      edgePos[i] = new TransformEdgePos4(0, i * 2);
    aCornPerm = null;
    oCornPerm = null;
  }
}
