
final class PruneEdge4 {
  private byte[] distance;
  private int len;

  private static final String[] txt =
    {"UF", "UR", "UB", "UL", "DF", "DR", "DB", "DL", "FR", "FL", "BR", "BL"};

  public int distance(int e1, int e2) {
    return distance[e1 * len + (e2 >> 1)] >> (e2 & 1) * 4 & 15;
  }

  public PruneEdge4(Transform4 transform, int eActive, int pos1, int pos2, int mask) {
    PackEdgePos4 packEdgePos1 = new PackEdgePos4(eActive, pos1);
    int e1Len = packEdgePos1.len();
    int e1Start = packEdgePos1.startLen();
    PackEdgePos4 packEdgePos2 = new PackEdgePos4(eActive, pos2);
    int e2Len = packEdgePos2.len();
    int e2Start = packEdgePos2.startLen();
    len = e2Len + 1 >> 1;
    distance = new byte[e1Len * len];
    for (int e1 = 0; e1 < e1Len; e1++)
      for (int e2 = 0; e2 < len; e2++)
        distance[e1 * len + e2] = (byte)255;
    System.err.print(" " + txt[pos1 / 2] + " edge - " + txt[pos2 / 2] + " edge position:");
    System.err.print(" " + e1Start + "x" + e2Start + "=" + e1Start * e2Start);
    for (int e1 = 0; e1 < e1Start; e1++) {
      for (int e2 = 0; e2 < e2Start; e2++) {
        int s1 = packEdgePos1.start(e1);
        int s2 = packEdgePos2.start(e2);
        distance[s1 * len + (s2 >> 1)] ^= 15 << (s2 & 1) * 4;
      }
    }
    int states = e1Start * e2Start;
    byte depth = 0;
    int total = 0;
    while (states > 0) {
      total += states;
      //System.err.println("   " + CubeReader4.padInt(depth, 2) + " " +
       //CubeReader4.padInt(states, 8) + " " + CubeReader4.padInt(total, 10));
      states = 0;
      depth++;
      for (int e1 = 0; e1 < e1Len; e1++) {
        for (int e2 = 0; e2 < e2Len; e2++) {
          if (distance(e1, e2) == depth - 1) {
            for (int t = 0; t < Turn4.NUM; t++) {
              if ((Turn4.turnMask[t] & mask) != 0) {
                int ne1 = transform.edgePos[pos1 / 2].turn[t][e1];
                int ne2 = transform.edgePos[pos2 / 2].turn[t][e2];
                int ind = ne1 * len + (ne2 >> 1);
                int sh = (ne2 & 1) * 4;
                if ((distance[ind] >> sh & 15) > depth) {
                  distance[ind] = (byte)(distance[ind] & ~(15 << sh) | depth << sh);
                  states++;
                }
              }
            }
          }
        }
      }
    }
    System.err.println(" -> " + total + " / " + (depth - 1));
  }
}
