
final class PruneCornTwistMid4 {
  private byte[] distance;
  private int len;

  private static final String[] txt = {"U", "D", "F", "B", "L", "R"};

  public int distance(int ct, int ml) {
    return distance[ct * len + (ml >> 1)] >> (ml & 1) * 4 & 15;
  }

  public PruneCornTwistMid4(Transform4 transform, int coActive, int mActive, int pos, int mask) {
    PackCornTwist4 packCornTwist = new PackCornTwist4(coActive);
    int ctLen = packCornTwist.len();
    int ctStart = packCornTwist.startLen();
    PackMidLoc4 packMidLoc = new PackMidLoc4(mActive, pos);
    int mlLen = packMidLoc.len();
    int mlStart = packMidLoc.startLen();
    len = mlLen + 1 >> 1;
    distance = new byte[ctLen * len];
    for (int ct = 0; ct < ctLen; ct++)
      for (int ml = 0; ml < len; ml++)
        distance[ct * len + ml] = (byte)255;
    System.err.print(" corner twist - " + txt[pos / 4] + " center location:");
    System.err.print(" " + ctStart + "x" + mlStart + "=" + ctStart * mlStart);
    for (int ct = 0; ct < ctStart; ct++) {
      for (int ml = 0; ml < mlStart; ml++) {
        int s1 = packCornTwist.start(ct);
        int s2 = packMidLoc.start(ml);
        distance[s1 * len + (s2 >> 1)] ^= 15 << (s2 & 1) * 4;
      }
    }
    int states = ctStart * mlStart;
    byte depth = 0;
    int total = 0;
    while (states > 0) {
      total += states;
      //System.err.println("   " + CubeReader4.padInt(depth, 2) + " " +
       //CubeReader4.padInt(states, 8) + " " + CubeReader4.padInt(total, 10));
      states = 0;
      depth++;
      for (int ct = 0; ct < ctLen; ct++) {
        for (int ml = 0; ml < mlLen; ml++) {
          if (distance(ct, ml) == depth - 1) {
            for (int t = 0; t < Turn4.NUM; t++) {
              if ((Turn4.turnMask[t] & mask) != 0) {
                int nct = transform.cornTwist.turn[t][ct];
                int nml = transform.midLoc[pos / 4].turn[t][ml];
                int ind = nct * len + (nml >> 1);
                int sh = (nml & 1) * 4;
                if ((distance[ind] >> sh & 15) > depth) {
                  distance[ind] = (byte)(distance[ind] & ~(15 << sh) | depth << sh);
                  states++;
                }
              }
            }
          }
        }
      }
    }
    System.err.println(" -> " + total + " / " + (depth - 1));
  }
}
