
final class PruneCorn4 {
  private byte[] distance;
  private int len;

  public int distance(int ct, int cp) {
    return distance[ct * len + (cp >> 1)] >> (cp & 1) * 4 & 15;
  }

  public PruneCorn4(Transform4 transform, int coActive, int cActive, int mask) {
    PackCornTwist4 packCornTwist = new PackCornTwist4(coActive);
    int ctLen = packCornTwist.len();
    int ctStart = packCornTwist.startLen();
    PackCornPerm4 packCornPerm = new PackCornPerm4(cActive);
    int cpLen = packCornPerm.len();
    int cpStart = packCornPerm.startLen();
    len = cpLen + 1 >> 1;
    distance = new byte[ctLen * len];
    for (int ct = 0; ct < ctLen; ct++)
      for (int cp = 0; cp < len; cp++)
        distance[ct * len + cp] = (byte)255;
    System.err.print(" corner twist - corner permutation:");
    System.err.print(" " + ctStart + "x" + cpStart + "=" + ctStart * cpStart);
    for (int ct = 0; ct < ctStart; ct++) {
      for (int cp = 0; cp < cpStart; cp++) {
        int s1 = packCornTwist.start(ct);
        int s2 = packCornPerm.start(cp);
        distance[s1 * len + (s2 >> 1)] ^= 15 << (s2 & 1) * 4;
      }
    }
    int states = ctStart * cpStart;
    byte depth = 0;
    int total = 0;
    while (states > 0) {
      total += states;
      //System.err.println("   " + CubeReader4.padInt(depth, 2) + " " +
       //CubeReader4.padInt(states, 8) + " " + CubeReader4.padInt(total, 10));
      states = 0;
      depth++;
      for (int ct = 0; ct < ctLen; ct++) {
        for (int cp = 0; cp < cpLen; cp++) {
          if (distance(ct, cp) == depth - 1) {
            for (int t = 0; t < Turn4.NUM; t++) {
              if ((Turn4.turnMask[t] & mask) != 0) {
                int nct = transform.cornTwist.turn[t][ct];
                int ncp = transform.cornPerm.turn[t][cp];
                int ind = nct * len + (ncp >> 1);
                int sh = (ncp & 1) * 4;
                if ((distance[ind] >> sh & 15) > depth) {
                  distance[ind] = (byte)(distance[ind] & ~(15 << sh) | depth << sh);
                  states++;
                }
              }
            }
          }
        }
      }
    }
    System.err.println(" -> " + total + " / " + (depth - 1));
  }
}
