
public final class Prune4 {
  public final PruneCorn4 corn;
  public final PruneCornTwistMid4 ctMidU;
  public final PruneCornTwistMid4 ctMidD;
  public final PruneCornTwistMid4 ctMidF;
  public final PruneCornTwistMid4 ctMidB;
  public final PruneCornTwistMid4 ctMidL;
  public final PruneCornTwistMid4 ctMidR;
  public final PruneEdge4 edgeUFDB;
  public final PruneEdge4 edgeURDL;
  public final PruneEdge4 edgeUBDF;
  public final PruneEdge4 edgeULDR;
  public final PruneEdge4 edgeFRBL;
  public final PruneEdge4 edgeFLBR;
  public final PruneACornEdge4[] aCornEdge;
  public final PruneOCornEdge4[] oCornEdge;

  private int max(int a, int b) {
    return a > b ? a : b;
  }

  private int max(int a, int b, int c) {
    return max(max(a, b), c);
  }

  private int max(int a, int b, int c, int d) {
    return max(max(a, b), max(c, d));
  }

  private int max(int a, int b, int c, int d, int e, int f) {
    return max(max(a, b), max(c, d), max(e, f));
  }

  public int distance(int ct, int cp,
    int mu, int md, int mf, int mb, int ml, int mr,
    int euf, int eur, int eub, int eul, int edf, int edr, int edb, int edl, int efr, int efl, int ebr, int ebl,
    int ac, int oc) {
    int max = 0;
    max = max(max, aCornEdge[0].distance(ac, euf), oCornEdge[0].distance(oc, euf));
    max = max(max, aCornEdge[1].distance(ac, eur), oCornEdge[1].distance(oc, eur));
    max = max(max, aCornEdge[2].distance(ac, eub), oCornEdge[2].distance(oc, eub));
    max = max(max, aCornEdge[3].distance(ac, eul), oCornEdge[3].distance(oc, eul));
    max = max(max, aCornEdge[4].distance(ac, edf), oCornEdge[4].distance(oc, edf));
    max = max(max, aCornEdge[5].distance(ac, edr), oCornEdge[5].distance(oc, edr));
    max = max(max, aCornEdge[6].distance(ac, edb), oCornEdge[6].distance(oc, edb));
    max = max(max, aCornEdge[7].distance(ac, edl), oCornEdge[7].distance(oc, edl));
    max = max(max, aCornEdge[8].distance(ac, efr), oCornEdge[8].distance(oc, efr));
    max = max(max, aCornEdge[9].distance(ac, efl), oCornEdge[9].distance(oc, efl));
    max = max(max, aCornEdge[10].distance(ac, ebr), oCornEdge[10].distance(oc, ebr));
    max = max(max, aCornEdge[11].distance(ac, ebl), oCornEdge[11].distance(oc, ebl));
    return max(max, corn.distance(ct, cp),
               max(ctMidU.distance(ct, mu),
                   ctMidD.distance(ct, md),
                   ctMidF.distance(ct, mf),
                   ctMidB.distance(ct, mb),
                   ctMidL.distance(ct, ml),
                   ctMidR.distance(ct, mr)),
               max(edgeUFDB.distance(euf, edb),
                   edgeURDL.distance(eur, edl),
                   edgeUBDF.distance(eub, edf),
                   edgeULDR.distance(eul, edr),
                   edgeFRBL.distance(efr, ebl),
                   edgeFLBR.distance(efl, ebr)));
  }

  public boolean over(int d, int ct, int cp,
    int mu, int md, int mf, int mb, int ml, int mr,
    int euf, int eur, int eub, int eul, int edf, int edr, int edb, int edl, int efr, int efl, int ebr, int ebl,
    int ac, int oc) {
    if (corn.distance(ct, cp) > d)
      return true;
    if (ctMidU.distance(ct, mu) > d)
      return true;
    if (ctMidD.distance(ct, md) > d)
      return true;
    if (ctMidF.distance(ct, mf) > d)
      return true;
    if (ctMidB.distance(ct, mb) > d)
      return true;
    if (ctMidL.distance(ct, ml) > d)
      return true;
    if (ctMidR.distance(ct, mr) > d)
      return true;
    if (edgeUFDB.distance(euf, edb) > d)
      return true;
    if (edgeURDL.distance(eur, edl) > d)
      return true;
    if (edgeUBDF.distance(eub, edf) > d)
      return true;
    if (edgeULDR.distance(eul, edr) > d)
      return true;
    if (edgeFRBL.distance(efr, ebl) > d)
      return true;
    if (edgeFLBR.distance(efl, ebr) > d)
      return true;
    if (aCornEdge[0].distance(ac, euf) > d)
      return true;
    if (aCornEdge[1].distance(ac, eur) > d)
      return true;
    if (aCornEdge[2].distance(ac, eub) > d)
      return true;
    if (aCornEdge[3].distance(ac, eul) > d)
      return true;
    if (aCornEdge[4].distance(ac, edf) > d)
      return true;
    if (aCornEdge[5].distance(ac, edr) > d)
      return true;
    if (aCornEdge[6].distance(ac, edb) > d)
      return true;
    if (aCornEdge[7].distance(ac, edl) > d)
      return true;
    if (aCornEdge[8].distance(ac, efr) > d)
      return true;
    if (aCornEdge[9].distance(ac, efl) > d)
      return true;
    if (aCornEdge[10].distance(ac, ebr) > d)
      return true;
    if (aCornEdge[11].distance(ac, ebl) > d)
      return true;
    if (oCornEdge[0].distance(oc, euf) > d)
      return true;
    if (oCornEdge[1].distance(oc, eur) > d)
      return true;
    if (oCornEdge[2].distance(oc, eub) > d)
      return true;
    if (oCornEdge[3].distance(oc, eul) > d)
      return true;
    if (oCornEdge[4].distance(oc, edf) > d)
      return true;
    if (oCornEdge[5].distance(oc, edr) > d)
      return true;
    if (oCornEdge[6].distance(oc, edb) > d)
      return true;
    if (oCornEdge[7].distance(oc, edl) > d)
      return true;
    if (oCornEdge[8].distance(oc, efr) > d)
      return true;
    if (oCornEdge[9].distance(oc, efl) > d)
      return true;
    if (oCornEdge[10].distance(oc, ebr) > d)
      return true;
    if (oCornEdge[11].distance(oc, ebl) > d)
      return true;
    return false;
  }

  public Prune4(Transform4 transform, CubeState4 state) {
    System.err.println("Pruning tables...");
    corn = new PruneCorn4(transform, state.coActive, state.cActive, state.turnMask);
    ctMidU = new PruneCornTwistMid4(transform, state.coActive, state.mActive, 0, state.turnMask);
    ctMidD = new PruneCornTwistMid4(transform, state.coActive, state.mActive, 4, state.turnMask);
    ctMidF = new PruneCornTwistMid4(transform, state.coActive, state.mActive, 8, state.turnMask);
    ctMidB = new PruneCornTwistMid4(transform, state.coActive, state.mActive, 12, state.turnMask);
    ctMidL = new PruneCornTwistMid4(transform, state.coActive, state.mActive, 16, state.turnMask);
    ctMidR = new PruneCornTwistMid4(transform, state.coActive, state.mActive, 20, state.turnMask);
    edgeUFDB = new PruneEdge4(transform, state.eActive, 0, 12, state.turnMask);
    edgeURDL = new PruneEdge4(transform, state.eActive, 2, 14, state.turnMask);
    edgeUBDF = new PruneEdge4(transform, state.eActive, 4, 8, state.turnMask);
    edgeULDR = new PruneEdge4(transform, state.eActive, 6, 10, state.turnMask);
    edgeFRBL = new PruneEdge4(transform, state.eActive, 16, 22, state.turnMask);
    edgeFLBR = new PruneEdge4(transform, state.eActive, 18, 20, state.turnMask);
    aCornEdge = new PruneACornEdge4[12];
    oCornEdge = new PruneOCornEdge4[12];
    for (int i = 0; i < 12; i++) {
      aCornEdge[i] = new PruneACornEdge4(transform, state.cActive, state.eActive, i * 2, state.turnMask);
      oCornEdge[i] = new PruneOCornEdge4(transform, state.cActive, state.eActive, i * 2, state.turnMask);
    }
  }
}
