/**
 * Corner permutations for 4x4x4.
 * Only UFL corner and the opposite ones are considered (UBR, DFR, DBL)
 * DBR corner is fixed in its position.
 */
public class PackOCornPerm4 {
  private final Comb comb;
  private int active; // which corners are specified

  public PackOCornPerm4(int active) {
    this.active = active;
    comb = new Comb(7, active(active));
  }

  private static int active(int active) {
    int r = 0;
    if ((active & 0x02) == 0) r++; // UBR
    if ((active & 0x08) == 0) r++; // UFL
    if ((active & 0x10) == 0) r++; // DFR
    if ((active & 0x40) == 0) r++; // DBL
    return r;
  }

  public int pack() {
    return comb.varPack();
  }

  public void unpack(int c) {
    comb.varUnpack(c);
  }

  public int len() {
    return comb.var;
  }

  public int startLen() {
    return 1;
  }

  public int start(int pos) {
    int r = 1;
    comb.clear();
    if ((active & 0x02) == 0) comb.a[1] = r++; // URB
    if ((active & 0x08) == 0) comb.a[3] = r++; // ULF
    if ((active & 0x10) == 0) comb.a[4] = r++; // DRF
    if ((active & 0x40) == 0) comb.a[6] = r++; // DLB
    return pack();
  }

  public void cycle(int i1, int i2, int i3, int i4) {
    comb.cycle(i1, i2, i3, i4);
  }

  public void fill(int[] a) {
    comb.fill(a);
  }
}
