/**
 * Corner permutations for 4x4x4.
 * Only UFL corner and the adjacent ones are considered (UFR, UBL, DFL)
 * DBR corner is fixed in its position.
 */
public class PackACornPerm4 {
  private final Comb comb;
  private int active; // which corners are specified

  public PackACornPerm4(int active) {
    this.active = active;
    comb = new Comb(7, active(active));
  }

  private static int active(int active) {
    int r = 0;
    if ((active & 0x01) == 0) r++; // UFR
    if ((active & 0x04) == 0) r++; // UBL
    if ((active & 0x08) == 0) r++; // UFL
    if ((active & 0x20) == 0) r++; // DFL
    return r;
  }

  public int pack() {
    return comb.varPack();
  }

  public void unpack(int c) {
    comb.varUnpack(c);
  }

  public int len() {
    return comb.var;
  }

  public int startLen() {
    return 1;
  }

  public int start(int pos) {
    int r = 1;
    comb.clear();
    if ((active & 0x01) == 0) comb.a[0] = r++; // UFR
    if ((active & 0x04) == 0) comb.a[2] = r++; // UBL
    if ((active & 0x08) == 0) comb.a[3] = r++; // ULF
    if ((active & 0x20) == 0) comb.a[5] = r++; // DFL
    return pack();
  }

  public void cycle(int i1, int i2, int i3, int i4) {
    comb.cycle(i1, i2, i3, i4);
  }

  public void fill(int[] a) {
    comb.fill(a);
  }
}
