
public final class Solution4 {
  private final class Node {
    public int restDepth;
    public int turn;
    public int turnList;
    // cube description values
    public int cornTwist;
    public int cornPerm;
    public int midLocU;
    public int midLocD;
    public int midLocF;
    public int midLocB;
    public int midLocL;
    public int midLocR;
    public int edgePosUF;
    public int edgePosUR;
    public int edgePosUB;
    public int edgePosUL;
    public int edgePosDF;
    public int edgePosDR;
    public int edgePosDB;
    public int edgePosDL;
    public int edgePosFR;
    public int edgePosFL;
    public int edgePosBR;
    public int edgePosBL;
    public int aCornPerm;
    public int oCornPerm;
  }

  public static final String[] turnSymbol = {
    "U", "U2", "U'",
    "F", "F2", "F'",
    "L", "L2", "L'",
    "Uu", "U2u2", "U'u'",
    "Ff", "F2f2", "F'f'",
    "Ll", "L2l2", "L'l'",
    "u", "u2", "u'",
    "d", "d2", "d'",
    "f", "f2", "f'",
    "b", "b2", "b'",
    "l", "l2", "l'",
    "r", "r2", "r'",
    "ud'", "u2d2", "u'd",
    "fb'", "f2b2", "f'b",
    "lr'", "l2r2", "l'r",
    "Uud'", "U2u2d2", "U'u'd",
    "Ffb'", "F2f2b2", "F'f'b",
    "Llr'", "L2l2r2", "L'l'r",
  };

  private Transform4 transform;
  private Prune4 prune;
  private TurnList4 turnList;
  private CubeState4 state;

  private int minLength; // length of the shortest solution
  private Node[] stack = new Node[100];
  private int stackn;
  private long soln, prn, pry; // statistics

  public Solution4(Transform4 transform, Prune4 prune, TurnList4 turnList) {
    this.transform = transform;
    this.prune = prune;
    this.turnList = turnList;
    for (int i = 0; i < stack.length; i++)
      stack[i] = new Node();
  }

  public void solve(CubeState4 state) {
    this.state = state;
    solve();
  }

  private void solve() {
    minLength = state.minimum; // the minimal length found
    soln = pry = prn = 0; // statistics
    // set the root node to the initial configuration
    Node node = stack[0]; 
    node.cornTwist = state.cornTwist;
    node.cornPerm = state.cornPerm;
    node.midLocU = state.midLocU;
    node.midLocD = state.midLocD;
    node.midLocF = state.midLocF;
    node.midLocB = state.midLocB;
    node.midLocL = state.midLocL;
    node.midLocR = state.midLocR;
    node.edgePosUF = state.edgePosUF;
    node.edgePosUR = state.edgePosUR;
    node.edgePosUB = state.edgePosUB;
    node.edgePosUL = state.edgePosUL;
    node.edgePosDF = state.edgePosDF;
    node.edgePosDR = state.edgePosDR;
    node.edgePosDB = state.edgePosDB;
    node.edgePosDL = state.edgePosDL;
    node.edgePosFR = state.edgePosFR;
    node.edgePosFL = state.edgePosFL;
    node.edgePosBR = state.edgePosBR;
    node.edgePosBL = state.edgePosBL;
    node.aCornPerm = state.aCornPerm;
    node.oCornPerm = state.oCornPerm;
    node.turn = -2; // unused
    node.turnList = 0; // all turns allowed
    // IDA* depth-first search
    int maxDepth = prune.distance(
      node.cornTwist,
      node.cornPerm,
      node.midLocU,
      node.midLocD,
      node.midLocF,
      node.midLocB,
      node.midLocL,
      node.midLocR,
      node.edgePosUF,
      node.edgePosUR,
      node.edgePosUB,
      node.edgePosUL,
      node.edgePosDF,
      node.edgePosDR,
      node.edgePosDB,
      node.edgePosDL,
      node.edgePosFR,
      node.edgePosFL,
      node.edgePosBR,
      node.edgePosBL,
      node.aCornPerm,
      node.oCornPerm
    );
    if (maxDepth < state.depth)
      maxDepth = state.depth;
    for (int d = maxDepth; d <= minLength; d++) {
      System.err.println("depth " + d + "...");
      search(d);
    }
    System.err.println("Done. (" + soln + " solutions found)");
    if (prn > 0) {
      long n = prn < 10000 ? pry * 100 / prn : pry / (prn / 100);
      System.err.println(" (" + n + "% save - " + pry + " of " + prn + " entries)");
    }
  }

  private void search(int i) {
    stackn = 0;
    stack[0].restDepth = i; // the rest depth is the largest possible
    stack[1].turn = -1; // no turn yet
    while (stackn >= 0) {
      if (stack[stackn].restDepth == 0) { // solution found ?
        display();
        minLength = stack[0].restDepth; // new minimum
        soln++;
        stackn--;
      }
      else {
        Node s = stack[stackn];
        Node ns = stack[stackn + 1];
        int t = ns.turn + 1;
        while (t < Turn4.NUM) {
          int tl = turnList.next[s.turnList * Turn4.NUM + t];
          if (tl == -1) { // illegal turn
            t++;
            continue;
          }
          ns.restDepth = s.restDepth - 1; // decrease the rest depth
          ns.cornTwist = transform.cornTwist.turn[t][s.cornTwist];
          ns.cornPerm = transform.cornPerm.turn[t][s.cornPerm];
          ns.midLocU = transform.midLoc[0].turn[t][s.midLocU];
          ns.midLocD = transform.midLoc[1].turn[t][s.midLocD];
          ns.midLocF = transform.midLoc[2].turn[t][s.midLocF];
          ns.midLocB = transform.midLoc[3].turn[t][s.midLocB];
          ns.midLocL = transform.midLoc[4].turn[t][s.midLocL];
          ns.midLocR = transform.midLoc[5].turn[t][s.midLocR];
          ns.edgePosUF = transform.edgePos[0].turn[t][s.edgePosUF];
          ns.edgePosUR = transform.edgePos[1].turn[t][s.edgePosUR];
          ns.edgePosUB = transform.edgePos[2].turn[t][s.edgePosUB];
          ns.edgePosUL = transform.edgePos[3].turn[t][s.edgePosUL];
          ns.edgePosDF = transform.edgePos[4].turn[t][s.edgePosDF];
          ns.edgePosDR = transform.edgePos[5].turn[t][s.edgePosDR];
          ns.edgePosDB = transform.edgePos[6].turn[t][s.edgePosDB];
          ns.edgePosDL = transform.edgePos[7].turn[t][s.edgePosDL];
          ns.edgePosFR = transform.edgePos[8].turn[t][s.edgePosFR];
          ns.edgePosFL = transform.edgePos[9].turn[t][s.edgePosFL];
          ns.edgePosBR = transform.edgePos[10].turn[t][s.edgePosBR];
          ns.edgePosBL = transform.edgePos[11].turn[t][s.edgePosBL];
          ns.aCornPerm = transform.aCornPerm.turn[t][s.aCornPerm];
          ns.oCornPerm = transform.oCornPerm.turn[t][s.oCornPerm];
          prn++;
          if (prune.over(ns.restDepth,
                ns.cornTwist,
                ns.cornPerm,
                ns.midLocU,
                ns.midLocD,
                ns.midLocF,
                ns.midLocB,
                ns.midLocL,
                ns.midLocR,
                ns.edgePosUF,
                ns.edgePosUR,
                ns.edgePosUB,
                ns.edgePosUL,
                ns.edgePosDF,
                ns.edgePosDR,
                ns.edgePosDB,
                ns.edgePosDL,
                ns.edgePosFR,
                ns.edgePosFL,
                ns.edgePosBR,
                ns.edgePosBL,
                ns.aCornPerm,
                ns.oCornPerm)) {
            pry++;
            t++;
            continue;
          }
          ns.turn = t; // save the last turn
          ns.turnList = tl;
          break;
        }
        if (t == Turn4.NUM)
          stackn--; // return to the previous depth
        else {
          stackn++; // go to the next depth
          stack[stackn + 1].turn = -1;
        }
      }
    }
  }

  private void display() {
    int len = 0;
    for (int i = 1; i <= stackn; i++) {
      int t = stack[i].turn;
      len++;
      System.out.print(turnSymbol[t] + " ");
    }
    System.out.println("(" + len + ")");
  }
}
