/*
 * Decompiled with CFR 0.152.
 */
public final class Comb {
    public final int[] a;
    private final int n;
    private final int k;
    public final int facN;
    public final int facK;
    public final int comb;
    public final int var;

    public Comb(int n, int n2) {
        this.n = n;
        this.k = n2;
        this.facN = Comb.fac(n);
        this.facK = Comb.fac(n2);
        this.comb = Comb.comb(n, n2);
        this.var = Comb.var(n, n2);
        this.a = new int[n];
    }

    public Comb(int n) {
        this(n, n);
    }

    public void fill(int[] nArray) {
        int n = 0;
        while (n < this.n) {
            this.a[n] = nArray[n];
            ++n;
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.n) {
            this.a[n] = 0;
            ++n;
        }
    }

    public static int fac(int n) {
        int n2 = 1;
        int n3 = n;
        while (n3 > 1) {
            n2 *= n3;
            --n3;
        }
        return n2;
    }

    public static int comb(int n, int n2) {
        long l = 1L;
        long l2 = 1L;
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            l *= (long)n3;
            l2 *= (long)n4;
            --n3;
            --n4;
        }
        return (int)(l / l2);
    }

    public static int var(int n, int n2) {
        int n3 = 1;
        int n4 = n;
        int n5 = n2;
        while (n5 > 0) {
            n3 *= n4;
            --n4;
            --n5;
        }
        return n3;
    }

    public int permPack() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.n - 1) {
            int n3 = n2 + 1;
            while (n3 < this.n) {
                if (this.a[n3] < this.a[n2]) {
                    ++n;
                }
                ++n3;
            }
            n *= this.n - n2 - 1;
            ++n2;
        }
        return n;
    }

    public void permUnpack(int n) {
        this.a[this.n - 1] = 0;
        int n2 = this.n - 2;
        while (n2 >= 0) {
            this.a[n2] = n % (this.n - n2);
            n /= this.n - n2;
            int n3 = this.n - 1;
            while (n3 > n2) {
                if (this.a[n3] >= this.a[n2]) {
                    int n4 = n3;
                    this.a[n4] = this.a[n4] + 1;
                }
                --n3;
            }
            --n2;
        }
    }

    public int mixPermPack() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.n - 1) {
            if (this.a[n2] > 0) {
                int n3 = 0;
                int n4 = n2 + 1;
                while (n4 < this.n) {
                    if (this.a[n4] != 0) {
                        ++n3;
                        if (this.a[n4] < this.a[n2]) {
                            ++n;
                        }
                    }
                    ++n4;
                }
                if (n3 <= 1) {
                    return n;
                }
                n *= n3;
            }
            ++n2;
        }
        return 0;
    }

    public void mixPermUnpack(int n) {
        int n2 = 0;
        int n3 = this.n - 1;
        while (n3 >= 0) {
            if (this.a[n3] > 0) {
                this.a[n3] = n % ++n2 + 1;
                n /= n2;
                int n4 = this.n - 1;
                while (n4 > n3) {
                    if (this.a[n4] > 0 && this.a[n4] >= this.a[n3]) {
                        int n5 = n4;
                        this.a[n5] = this.a[n5] + 1;
                    }
                    --n4;
                }
            }
            --n3;
        }
    }

    public int combPack() {
        int n = 0;
        int n2 = 0;
        int n3 = this.k;
        while (n2 < this.n - n3) {
            if (this.a[n2] > 0) {
                n += Comb.comb(this.n - n2 - 1, n3--);
            }
            ++n2;
        }
        return n;
    }

    public void combUnpack(int n) {
        int n2 = 0;
        int n3 = this.k;
        while (n2 < this.n) {
            int n4 = Comb.comb(this.n - n2 - 1, n3);
            if (n4 <= n) {
                n -= n4;
                this.a[n2] = 1;
                --n3;
            } else {
                this.a[n2] = 0;
            }
            ++n2;
        }
    }

    public int varPack() {
        return this.combPack() * this.facK + this.mixPermPack();
    }

    public void varUnpack(int n) {
        this.combUnpack(n / this.facK);
        this.mixPermUnpack(n % this.facK);
    }

    public boolean checkPerm() {
        int[] nArray = new int[this.n];
        int n = 0;
        while (n < this.n) {
            if (this.a[n] < 0 || this.a[n] >= this.n) {
                return false;
            }
            int n2 = this.a[n];
            nArray[n2] = nArray[n2] + 1;
            ++n;
        }
        int n3 = 0;
        while (n3 < this.n) {
            if (nArray[n3] != 1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean checkVar() {
        int[] nArray = new int[this.n];
        int n = 0;
        while (n < this.n) {
            if (this.a[n] < 0 || this.a[n] > this.n) {
                return false;
            }
            if (this.a[n] > 0) {
                int n2 = this.a[n] - 1;
                nArray[n2] = nArray[n2] + 1;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < this.n) {
            if (nArray[n3] > 1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public int permParity() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.n - 1) {
            int n3 = n2 + 1;
            while (n3 < this.n) {
                if (this.a[n2] > this.a[n3]) {
                    n = 1 - n;
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public int varParity() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.n) {
            if (this.a[n2] == 0) {
                if (n == -1) {
                    return -2;
                }
                n = -1;
            }
            ++n2;
        }
        if (n < 0) {
            return n;
        }
        return this.permParity();
    }

    public void swap(int n, int n2) {
        int n3 = this.a[n];
        this.a[n] = this.a[n2];
        this.a[n2] = n3;
    }

    public void cycle(int n, int n2, int n3, int n4) {
        int n5 = this.a[n];
        this.a[n] = this.a[n2];
        this.a[n2] = this.a[n3];
        this.a[n3] = this.a[n4];
        this.a[n4] = n5;
    }

    public String toString() {
        String string = "" + this.n + "/" + this.k + " [";
        int n = 0;
        while (n < this.a.length) {
            string = string + (n == 0 ? "" : " ") + this.a[n];
            ++n;
        }
        return string + "]";
    }
}

